/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceLists;
import com.lambdaworks.redis.masterslave.MasterSlaveChannelWriter;
import com.lambdaworks.redis.masterslave.MasterSlaveConnectionProvider;
import com.lambdaworks.redis.masterslave.MasterSlaveTopologyProvider;
import com.lambdaworks.redis.masterslave.MasterSlaveTopologyRefresh;
import com.lambdaworks.redis.masterslave.SentinelTopologyProvider;
import com.lambdaworks.redis.masterslave.SentinelTopologyRefresh;
import com.lambdaworks.redis.masterslave.StatefulRedisMasterSlaveConnection;
import com.lambdaworks.redis.masterslave.StatefulRedisMasterSlaveConnectionImpl;
import com.lambdaworks.redis.masterslave.StaticMasterSlaveTopologyProvider;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MasterSlave {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(MasterSlave.class);

    public static <K, V> StatefulRedisMasterSlaveConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        LettuceAssert.notNull(redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
        if (MasterSlave.isSentinel(redisURI)) {
            return MasterSlave.connectSentinel(redisClient, codec, redisURI);
        }
        return MasterSlave.connectMasterSlave(redisClient, codec, redisURI);
    }

    public static <K, V> StatefulRedisMasterSlaveConnection<K, V> connect(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull(redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        List<RedisURI> uriList = LettuceLists.newList(redisURIs);
        LettuceAssert.isTrue(!uriList.isEmpty(), "RedisURIs must not be empty");
        if (MasterSlave.isSentinel(uriList.get(0))) {
            return MasterSlave.connectSentinel(redisClient, codec, uriList.get(0));
        }
        return MasterSlave.connectStaticMasterSlave(redisClient, codec, uriList);
    }

    private static <K, V> StatefulRedisMasterSlaveConnection<K, V> connectSentinel(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        SentinelTopologyProvider topologyProvider = new SentinelTopologyProvider(redisURI.getSentinelMasterId(), redisClient, redisURI);
        SentinelTopologyRefresh sentinelTopologyRefresh = new SentinelTopologyRefresh(redisClient, redisURI.getSentinelMasterId(), redisURI.getSentinels());
        MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(redisClient, topologyProvider);
        MasterSlaveConnectionProvider connectionProvider = new MasterSlaveConnectionProvider(redisClient, codec, redisURI, Collections.emptyMap());
        connectionProvider.setKnownNodes(refresh.getNodes(redisURI));
        MasterSlaveChannelWriter<K, V> channelWriter = new MasterSlaveChannelWriter<K, V>(connectionProvider);
        StatefulRedisMasterSlaveConnectionImpl<K, V> connection = new StatefulRedisMasterSlaveConnectionImpl<K, V>(channelWriter, codec, redisURI.getTimeout(), redisURI.getUnit());
        connection.setOptions(redisClient.getOptions());
        Runnable runnable = () -> {
            try {
                LOG.debug("Refreshing topology");
                List<RedisNodeDescription> nodes = refresh.getNodes(redisURI);
                LOG.debug("New topology: {}", nodes);
                connectionProvider.setKnownNodes(nodes);
            }
            catch (Exception e) {
                LOG.error("Error during background refresh", (Throwable)e);
            }
        };
        try {
            connection.registerCloseables(new ArrayList<Closeable>(), sentinelTopologyRefresh);
            sentinelTopologyRefresh.bind(runnable);
        }
        catch (RuntimeException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    private static <K, V> StatefulRedisMasterSlaveConnection<K, V> connectMasterSlave(RedisClient redisClient, RedisCodec<K, V> codec, RedisURI redisURI) {
        HashMap<RedisURI, StatefulRedisConnection<RedisURI, StatefulRedisConnection<K, V>>> initialConnections = new HashMap<RedisURI, StatefulRedisConnection<RedisURI, StatefulRedisConnection<K, V>>>();
        try {
            StatefulRedisConnection<K, V> nodeConnection = redisClient.connect(codec, redisURI);
            initialConnections.put(redisURI, nodeConnection);
            MasterSlaveTopologyProvider topologyProvider = new MasterSlaveTopologyProvider(nodeConnection, redisURI);
            List<RedisNodeDescription> nodes = topologyProvider.getNodes();
            RedisNodeDescription node = MasterSlave.getConnectedNode(redisURI, nodes);
            if (node.getRole() != RedisInstance.Role.MASTER) {
                RedisNodeDescription master = MasterSlave.lookupMaster(nodes);
                nodeConnection = redisClient.connect(codec, master.getUri());
                initialConnections.put(master.getUri(), nodeConnection);
                topologyProvider = new MasterSlaveTopologyProvider(nodeConnection, master.getUri());
            }
            MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(redisClient, topologyProvider);
            MasterSlaveConnectionProvider<K, V> connectionProvider = new MasterSlaveConnectionProvider<K, V>(redisClient, codec, redisURI, initialConnections);
            connectionProvider.setKnownNodes(refresh.getNodes(redisURI));
            MasterSlaveChannelWriter<K, V> channelWriter = new MasterSlaveChannelWriter<K, V>(connectionProvider);
            StatefulRedisMasterSlaveConnectionImpl<K, V> connection = new StatefulRedisMasterSlaveConnectionImpl<K, V>(channelWriter, codec, redisURI.getTimeout(), redisURI.getUnit());
            connection.setOptions(redisClient.getOptions());
            return connection;
        }
        catch (RuntimeException e) {
            for (StatefulRedisConnection connection : initialConnections.values()) {
                connection.close();
            }
            throw e;
        }
    }

    private static <K, V> StatefulRedisMasterSlaveConnection<K, V> connectStaticMasterSlave(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        HashMap initialConnections = new HashMap();
        try {
            StaticMasterSlaveTopologyProvider topologyProvider = new StaticMasterSlaveTopologyProvider(redisClient, redisURIs);
            RedisURI seedNode = redisURIs.iterator().next();
            MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(redisClient, topologyProvider);
            MasterSlaveConnectionProvider<K, V> connectionProvider = new MasterSlaveConnectionProvider<K, V>(redisClient, codec, seedNode, initialConnections);
            List<RedisNodeDescription> nodes = refresh.getNodes(seedNode);
            if (nodes.isEmpty()) {
                throw new RedisException(String.format("Cannot determine topology from %s", redisURIs));
            }
            connectionProvider.setKnownNodes(nodes);
            MasterSlaveChannelWriter<K, V> channelWriter = new MasterSlaveChannelWriter<K, V>(connectionProvider);
            StatefulRedisMasterSlaveConnectionImpl<K, V> connection = new StatefulRedisMasterSlaveConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout(), seedNode.getUnit());
            connection.setOptions(redisClient.getOptions());
            return connection;
        }
        catch (RuntimeException e) {
            for (StatefulRedisConnection connection : initialConnections.values()) {
                connection.close();
            }
            throw e;
        }
    }

    private static RedisNodeDescription lookupMaster(List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = nodes.stream().filter(n -> n.getRole() == RedisInstance.Role.MASTER).findFirst();
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup master from " + nodes));
    }

    private static RedisNodeDescription getConnectedNode(RedisURI redisURI, List<RedisNodeDescription> nodes) {
        Optional<RedisNodeDescription> first = nodes.stream().filter(n -> MasterSlave.equals(redisURI, n)).findFirst();
        return first.orElseThrow(() -> new IllegalStateException("Cannot lookup node descriptor for connected node at " + redisURI));
    }

    private static boolean equals(RedisURI redisURI, RedisNodeDescription node) {
        return node.getUri().getHost().equals(redisURI.getHost()) && node.getUri().getPort() == redisURI.getPort();
    }

    private static boolean isSentinel(RedisURI redisURI) {
        return !redisURI.getSentinels().isEmpty();
    }
}

