/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterDistributionChannelWriter;
import com.lambdaworks.redis.cluster.ClusterFutureSyncInvocationHandler;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterAsyncCommandsImpl;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterConnection;
import com.lambdaworks.redis.cluster.RedisAdvancedClusterReactiveCommandsImpl;
import com.lambdaworks.redis.cluster.RedisState;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.async.RedisClusterAsyncCommands;
import com.lambdaworks.redis.cluster.api.rx.RedisAdvancedClusterReactiveCommands;
import com.lambdaworks.redis.cluster.api.sync.NodeSelection;
import com.lambdaworks.redis.cluster.api.sync.NodeSelectionCommands;
import com.lambdaworks.redis.cluster.api.sync.RedisAdvancedClusterCommands;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.models.command.CommandDetail;
import com.lambdaworks.redis.models.command.CommandDetailParser;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandArgsAccessor;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.CompleteableCommand;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@ChannelHandler.Sharable
public class StatefulRedisClusterConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisClusterConnection<K, V> {
    private Partitions partitions;
    private char[] password;
    private boolean readOnly;
    private String clientName;
    protected final RedisCodec<K, V> codec;
    protected final RedisAdvancedClusterCommands<K, V> sync;
    protected final RedisAdvancedClusterAsyncCommandsImpl<K, V> async;
    protected final RedisAdvancedClusterReactiveCommandsImpl<K, V> reactive;
    private volatile RedisState state;

    public StatefulRedisClusterConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, timeout, unit);
        this.codec = codec;
        this.async = new RedisAdvancedClusterAsyncCommandsImpl<K, V>(this, codec);
        this.sync = (RedisAdvancedClusterCommands)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), new Class[]{RedisAdvancedClusterConnection.class, RedisAdvancedClusterCommands.class}, this.syncInvocationHandler());
        this.reactive = new RedisAdvancedClusterReactiveCommandsImpl<K, V>(this, codec);
    }

    @Override
    public RedisAdvancedClusterCommands<K, V> sync() {
        return this.sync;
    }

    protected InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, RedisClusterAsyncCommands.class, NodeSelection.class, NodeSelectionCommands.class, this.async());
    }

    @Override
    public RedisAdvancedClusterAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisAdvancedClusterReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    @Deprecated
    protected RedisAdvancedClusterReactiveCommandsImpl<K, V> getReactiveCommands() {
        return this.reactive;
    }

    void inspectRedisState() {
        List<CommandDetail> commands = CommandDetailParser.parse(this.sync().command());
        this.state = new RedisState(commands);
    }

    RedisState getState() {
        return this.state;
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String host, int port) {
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    public ClusterDistributionChannelWriter<K, V> getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    @Override
    public void activated() {
        super.activated();
        if (this.password != null) {
            this.async.authAsync(this.password);
        }
        if (this.clientName != null) {
            this.setClientName(this.clientName);
        }
        if (this.readOnly) {
            this.async.readOnly();
        }
    }

    void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.clientName = clientName;
        this.dispatch(async);
    }

    @Override
    public <T, C extends RedisCommand<K, V, T>> C dispatch(C command) {
        Object local = command;
        if (local.getType().name().equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK")) {
                    char[] password = CommandArgsAccessor.getFirstCharArray(command.getArgs());
                    if (password != null) {
                        this.password = password;
                    } else {
                        String stringPassword = CommandArgsAccessor.getFirstString(command.getArgs());
                        if (stringPassword != null) {
                            this.password = stringPassword.toCharArray();
                        }
                    }
                }
            });
        }
        if (local.getType().name().equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = true;
                }
            });
        }
        if (local.getType().name().equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete((RedisCommand<K, V, T>)local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = false;
                }
            });
        }
        return (C)super.dispatch(local);
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setReadFrom(ReadFrom readFrom) {
        LettuceAssert.notNull(readFrom, "ReadFrom must not be null");
        this.getClusterDistributionChannelWriter().setReadFrom(readFrom);
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.getClusterDistributionChannelWriter().getReadFrom();
    }
}

