/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.data.experimental.AssertNextDataset;
import org.tensorflow.op.data.experimental.AutoShardDataset;
import org.tensorflow.op.data.experimental.BytesProducedStatsDataset;
import org.tensorflow.op.data.experimental.CSVDataset;
import org.tensorflow.op.data.experimental.ChooseFastestDataset;
import org.tensorflow.op.data.experimental.DatasetCardinality;
import org.tensorflow.op.data.experimental.DatasetToTFRecord;
import org.tensorflow.op.data.experimental.DenseToSparseBatchDataset;
import org.tensorflow.op.data.experimental.DirectedInterleaveDataset;
import org.tensorflow.op.data.experimental.GroupByReducerDataset;
import org.tensorflow.op.data.experimental.GroupByWindowDataset;
import org.tensorflow.op.data.experimental.IgnoreErrorsDataset;
import org.tensorflow.op.data.experimental.IteratorGetDevice;
import org.tensorflow.op.data.experimental.LatencyStatsDataset;
import org.tensorflow.op.data.experimental.LmdbDataset;
import org.tensorflow.op.data.experimental.MapAndBatchDataset;
import org.tensorflow.op.data.experimental.MapDataset;
import org.tensorflow.op.data.experimental.MatchingFilesDataset;
import org.tensorflow.op.data.experimental.MaxIntraOpParallelismDataset;
import org.tensorflow.op.data.experimental.NonSerializableDataset;
import org.tensorflow.op.data.experimental.ParallelInterleaveDataset;
import org.tensorflow.op.data.experimental.ParseExampleDataset;
import org.tensorflow.op.data.experimental.PrivateThreadPoolDataset;
import org.tensorflow.op.data.experimental.RandomDataset;
import org.tensorflow.op.data.experimental.RebatchDataset;
import org.tensorflow.op.data.experimental.ScanDataset;
import org.tensorflow.op.data.experimental.SetStatsAggregatorDataset;
import org.tensorflow.op.data.experimental.SleepDataset;
import org.tensorflow.op.data.experimental.SlidingWindowDataset;
import org.tensorflow.op.data.experimental.SqlDataset;
import org.tensorflow.op.data.experimental.StatsAggregatorHandle;
import org.tensorflow.op.data.experimental.StatsAggregatorSummary;
import org.tensorflow.op.data.experimental.TakeWhileDataset;
import org.tensorflow.op.data.experimental.ThreadPoolDataset;
import org.tensorflow.op.data.experimental.ThreadPoolHandle;
import org.tensorflow.op.data.experimental.UnbatchDataset;
import org.tensorflow.op.data.experimental.UniqueDataset;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class DataExperimentalOps {
    private final Scope scope;
    private final Ops ops;

    DataExperimentalOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AssertNextDataset assertNextDataset(Operand<? extends TType> inputDataset, Operand<TString> transformations, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return AssertNextDataset.create(this.scope, inputDataset, transformations, outputTypes, outputShapes);
    }

    public AutoShardDataset autoShardDataset(Operand<? extends TType> inputDataset, Operand<TInt64> numWorkers, Operand<TInt64> index, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, AutoShardDataset.Options ... options) {
        return AutoShardDataset.create(this.scope, inputDataset, numWorkers, index, outputTypes, outputShapes, options);
    }

    public BytesProducedStatsDataset bytesProducedStatsDataset(Operand<? extends TType> inputDataset, Operand<TString> tag, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return BytesProducedStatsDataset.create(this.scope, inputDataset, tag, outputTypes, outputShapes);
    }

    public CSVDataset cSVDataset(Operand<TString> filenames, Operand<TString> compressionType, Operand<TInt64> bufferSize, Operand<TBool> header, Operand<TString> fieldDelim, Operand<TBool> useQuoteDelim, Operand<TString> naValue, Operand<TInt64> selectCols, Iterable<Operand<?>> recordDefaults, List<Shape> outputShapes) {
        return CSVDataset.create(this.scope, filenames, compressionType, bufferSize, header, fieldDelim, useQuoteDelim, naValue, selectCols, recordDefaults, outputShapes);
    }

    public ChooseFastestDataset chooseFastestDataset(Iterable<Operand<? extends TType>> inputDatasets, Long numExperiments, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return ChooseFastestDataset.create(this.scope, inputDatasets, numExperiments, outputTypes, outputShapes);
    }

    public DatasetCardinality datasetCardinality(Operand<? extends TType> inputDataset) {
        return DatasetCardinality.create(this.scope, inputDataset);
    }

    public DatasetToTFRecord datasetToTFRecord(Operand<? extends TType> inputDataset, Operand<TString> filename, Operand<TString> compressionType) {
        return DatasetToTFRecord.create(this.scope, inputDataset, filename, compressionType);
    }

    public DenseToSparseBatchDataset denseToSparseBatchDataset(Operand<? extends TType> inputDataset, Operand<TInt64> batchSize, Operand<TInt64> rowShape, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return DenseToSparseBatchDataset.create(this.scope, inputDataset, batchSize, rowShape, outputTypes, outputShapes);
    }

    public DirectedInterleaveDataset directedInterleaveDataset(Operand<? extends TType> selectorInputDataset, Iterable<Operand<? extends TType>> dataInputDatasets, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return DirectedInterleaveDataset.create(this.scope, selectorInputDataset, dataInputDatasets, outputTypes, outputShapes);
    }

    public GroupByReducerDataset groupByReducerDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> keyFuncOtherArguments, Iterable<Operand<?>> initFuncOtherArguments, Iterable<Operand<?>> reduceFuncOtherArguments, Iterable<Operand<?>> finalizeFuncOtherArguments, ConcreteFunction keyFunc, ConcreteFunction initFunc, ConcreteFunction reduceFunc, ConcreteFunction finalizeFunc, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return GroupByReducerDataset.create(this.scope, inputDataset, keyFuncOtherArguments, initFuncOtherArguments, reduceFuncOtherArguments, finalizeFuncOtherArguments, keyFunc, initFunc, reduceFunc, finalizeFunc, outputTypes, outputShapes);
    }

    public GroupByWindowDataset groupByWindowDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> keyFuncOtherArguments, Iterable<Operand<?>> reduceFuncOtherArguments, Iterable<Operand<?>> windowSizeFuncOtherArguments, ConcreteFunction keyFunc, ConcreteFunction reduceFunc, ConcreteFunction windowSizeFunc, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return GroupByWindowDataset.create(this.scope, inputDataset, keyFuncOtherArguments, reduceFuncOtherArguments, windowSizeFuncOtherArguments, keyFunc, reduceFunc, windowSizeFunc, outputTypes, outputShapes);
    }

    public IgnoreErrorsDataset ignoreErrorsDataset(Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, IgnoreErrorsDataset.Options ... options) {
        return IgnoreErrorsDataset.create(this.scope, inputDataset, outputTypes, outputShapes, options);
    }

    public IteratorGetDevice iteratorGetDevice(Operand<? extends TType> resource) {
        return IteratorGetDevice.create(this.scope, resource);
    }

    public LatencyStatsDataset latencyStatsDataset(Operand<? extends TType> inputDataset, Operand<TString> tag, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return LatencyStatsDataset.create(this.scope, inputDataset, tag, outputTypes, outputShapes);
    }

    public LmdbDataset lmdbDataset(Operand<TString> filenames, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return LmdbDataset.create(this.scope, filenames, outputTypes, outputShapes);
    }

    public MapAndBatchDataset mapAndBatchDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, Operand<TInt64> batchSize, Operand<TInt64> numParallelCalls, Operand<TBool> dropRemainder, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, MapAndBatchDataset.Options ... options) {
        return MapAndBatchDataset.create(this.scope, inputDataset, otherArguments, batchSize, numParallelCalls, dropRemainder, f, outputTypes, outputShapes, options);
    }

    public MapDataset mapDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, MapDataset.Options ... options) {
        return MapDataset.create(this.scope, inputDataset, otherArguments, f, outputTypes, outputShapes, options);
    }

    public MatchingFilesDataset matchingFilesDataset(Operand<TString> patterns) {
        return MatchingFilesDataset.create(this.scope, patterns);
    }

    public MaxIntraOpParallelismDataset maxIntraOpParallelismDataset(Operand<? extends TType> inputDataset, Operand<TInt64> maxIntraOpParallelism, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return MaxIntraOpParallelismDataset.create(this.scope, inputDataset, maxIntraOpParallelism, outputTypes, outputShapes);
    }

    public NonSerializableDataset nonSerializableDataset(Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return NonSerializableDataset.create(this.scope, inputDataset, outputTypes, outputShapes);
    }

    public ParallelInterleaveDataset parallelInterleaveDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, Operand<TInt64> cycleLength, Operand<TInt64> blockLength, Operand<TBool> sloppy, Operand<TInt64> bufferOutputElements, Operand<TInt64> prefetchInputElements, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return ParallelInterleaveDataset.create(this.scope, inputDataset, otherArguments, cycleLength, blockLength, sloppy, bufferOutputElements, prefetchInputElements, f, outputTypes, outputShapes);
    }

    public ParseExampleDataset parseExampleDataset(Operand<? extends TType> inputDataset, Operand<TInt64> numParallelCalls, Iterable<Operand<?>> denseDefaults, List<String> sparseKeys, List<String> denseKeys, List<Class<? extends TType>> sparseTypes, List<Shape> denseShapes, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, ParseExampleDataset.Options ... options) {
        return ParseExampleDataset.create(this.scope, inputDataset, numParallelCalls, denseDefaults, sparseKeys, denseKeys, sparseTypes, denseShapes, outputTypes, outputShapes, options);
    }

    public PrivateThreadPoolDataset privateThreadPoolDataset(Operand<? extends TType> inputDataset, Operand<TInt64> numThreads, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return PrivateThreadPoolDataset.create(this.scope, inputDataset, numThreads, outputTypes, outputShapes);
    }

    public RandomDataset randomDataset(Operand<TInt64> seed, Operand<TInt64> seed2, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return RandomDataset.create(this.scope, seed, seed2, outputTypes, outputShapes);
    }

    public RebatchDataset rebatchDataset(Operand<? extends TType> inputDataset, Operand<TInt64> numReplicas, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, RebatchDataset.Options ... options) {
        return RebatchDataset.create(this.scope, inputDataset, numReplicas, outputTypes, outputShapes, options);
    }

    public ScanDataset scanDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> initialState, Iterable<Operand<?>> otherArguments, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, ScanDataset.Options ... options) {
        return ScanDataset.create(this.scope, inputDataset, initialState, otherArguments, f, outputTypes, outputShapes, options);
    }

    public SetStatsAggregatorDataset setStatsAggregatorDataset(Operand<? extends TType> inputDataset, Operand<? extends TType> statsAggregator, Operand<TString> tag, Operand<TString> counterPrefix, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return SetStatsAggregatorDataset.create(this.scope, inputDataset, statsAggregator, tag, counterPrefix, outputTypes, outputShapes);
    }

    public SleepDataset sleepDataset(Operand<? extends TType> inputDataset, Operand<TInt64> sleepMicroseconds, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return SleepDataset.create(this.scope, inputDataset, sleepMicroseconds, outputTypes, outputShapes);
    }

    public SlidingWindowDataset slidingWindowDataset(Operand<? extends TType> inputDataset, Operand<TInt64> windowSize, Operand<TInt64> windowShift, Operand<TInt64> windowStride, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return SlidingWindowDataset.create(this.scope, inputDataset, windowSize, windowShift, windowStride, outputTypes, outputShapes);
    }

    public SqlDataset sqlDataset(Operand<TString> driverName, Operand<TString> dataSourceName, Operand<TString> query, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return SqlDataset.create(this.scope, driverName, dataSourceName, query, outputTypes, outputShapes);
    }

    public StatsAggregatorHandle statsAggregatorHandle(StatsAggregatorHandle.Options ... options) {
        return StatsAggregatorHandle.create(this.scope, options);
    }

    public StatsAggregatorSummary statsAggregatorSummary(Operand<? extends TType> iterator) {
        return StatsAggregatorSummary.create(this.scope, iterator);
    }

    public TakeWhileDataset takeWhileDataset(Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, ConcreteFunction predicate, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return TakeWhileDataset.create(this.scope, inputDataset, otherArguments, predicate, outputTypes, outputShapes);
    }

    public ThreadPoolDataset threadPoolDataset(Operand<? extends TType> inputDataset, Operand<? extends TType> threadPool, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return ThreadPoolDataset.create(this.scope, inputDataset, threadPool, outputTypes, outputShapes);
    }

    public ThreadPoolHandle threadPoolHandle(Long numThreads, String displayName, ThreadPoolHandle.Options ... options) {
        return ThreadPoolHandle.create(this.scope, numThreads, displayName, options);
    }

    public UnbatchDataset unbatchDataset(Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return UnbatchDataset.create(this.scope, inputDataset, outputTypes, outputShapes);
    }

    public UniqueDataset uniqueDataset(Operand<? extends TType> inputDataset, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        return UniqueDataset.create(this.scope, inputDataset, outputTypes, outputShapes);
    }

    public final Ops ops() {
        return this.ops;
    }
}

