/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.dense.ShortDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.ShortSparseNdArray;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TUint16;

public final class TUint16Mapper
extends TensorMapper<TUint16> {
    @Override
    protected TUint16 mapDense(RawTensor tensor) {
        ShortDataBuffer buffer = TensorBuffers.toShorts(TUint16Mapper.nativeHandle(tensor));
        return new DenseTUint16(tensor, buffer);
    }

    @Override
    protected SparseTensor<TUint16> mapSparse(TInt64 indices, TUint16 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTUint16(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTUint16
    extends ShortSparseNdArray
    implements TUint16,
    SparseTensor<TUint16> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TUint16> type() {
            return TUint16.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TUint16 values() {
            return (TUint16)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTUint16(TInt64 indices, TUint16 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, (short)0, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTUint16
    extends ShortDenseNdArray
    implements TUint16 {
        final RawTensor rawTensor;

        public Class<TUint16> type() {
            return TUint16.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTUint16(RawTensor rawTensor, ShortDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

