/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.layout.DataLayouts;
import org.tensorflow.ndarray.impl.dense.FloatDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.FloatSparseNdArray;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat16;
import org.tensorflow.types.TInt64;

public final class TFloat16Mapper
extends TensorMapper<TFloat16> {
    @Override
    protected TFloat16 mapDense(RawTensor tensor) {
        DataBuffer buffer = DataLayouts.FLOAT16.applyTo((DataBuffer)TensorBuffers.toShorts(TFloat16Mapper.nativeHandle(tensor)));
        return new DenseTFloat16(tensor, (FloatDataBuffer)buffer);
    }

    @Override
    protected SparseTensor<TFloat16> mapSparse(TInt64 indices, TFloat16 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTFloat16(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTFloat16
    extends FloatSparseNdArray
    implements TFloat16,
    SparseTensor<TFloat16> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TFloat16> type() {
            return TFloat16.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TFloat16 values() {
            return (TFloat16)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTFloat16(TInt64 indices, TFloat16 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, 0.0f, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTFloat16
    extends FloatDenseNdArray
    implements TFloat16 {
        final RawTensor rawTensor;

        public Class<TFloat16> type() {
            return TFloat16.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat16(RawTensor rawTensor, FloatDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

