/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DenseToCSRSparseMatrix", inputsClass=Inputs.class)
public final class DenseToCSRSparseMatrix
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "DenseToCSRSparseMatrix";
    private Output<? extends TType> sparseOutput;

    public DenseToCSRSparseMatrix(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseOutput = operation.output(outputIdx++);
    }

    public static DenseToCSRSparseMatrix create(Scope scope, Operand<? extends TType> denseInput, Operand<TInt64> indices) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(denseInput.asOutput());
        opBuilder.addInput(indices.asOutput());
        return new DenseToCSRSparseMatrix(opBuilder.build());
    }

    public Output<? extends TType> sparseOutput() {
        return this.sparseOutput;
    }

    @Override
    public Output<TType> asOutput() {
        return this.sparseOutput;
    }

    @OpInputsMetadata(outputsClass=DenseToCSRSparseMatrix.class)
    public static class Inputs
    extends RawOpInputs<DenseToCSRSparseMatrix> {
        public final Operand<? extends TType> denseInput;
        public final Operand<TInt64> indices;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new DenseToCSRSparseMatrix(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.denseInput = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

