/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

@OpMetadata(opType="LoadAndRemapMatrix", inputsClass=Inputs.class)
public final class LoadAndRemapMatrix
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "LoadAndRemapMatrix";
    private Output<TFloat32> outputMatrix;

    public LoadAndRemapMatrix(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputMatrix = operation.output(outputIdx++);
    }

    public static LoadAndRemapMatrix create(Scope scope, Operand<TString> ckptPath, Operand<TString> oldTensorName, Operand<TInt64> rowRemapping, Operand<TInt64> colRemapping, Operand<TFloat32> initializingValues, Long numRows, Long numCols, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(ckptPath.asOutput());
        opBuilder.addInput(oldTensorName.asOutput());
        opBuilder.addInput(rowRemapping.asOutput());
        opBuilder.addInput(colRemapping.asOutput());
        opBuilder.addInput(initializingValues.asOutput());
        opBuilder.setAttr("num_rows", numRows);
        opBuilder.setAttr("num_cols", numCols);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxRowsInMemory == null) continue;
                opBuilder.setAttr("max_rows_in_memory", opts.maxRowsInMemory);
            }
        }
        return new LoadAndRemapMatrix(opBuilder.build());
    }

    public static Options maxRowsInMemory(Long maxRowsInMemory) {
        return new Options().maxRowsInMemory(maxRowsInMemory);
    }

    public Output<TFloat32> outputMatrix() {
        return this.outputMatrix;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.outputMatrix;
    }

    @OpInputsMetadata(outputsClass=LoadAndRemapMatrix.class)
    public static class Inputs
    extends RawOpInputs<LoadAndRemapMatrix> {
        public final Operand<TString> ckptPath;
        public final Operand<TString> oldTensorName;
        public final Operand<TInt64> rowRemapping;
        public final Operand<TInt64> colRemapping;
        public final Operand<TFloat32> initializingValues;
        public final long numRows;
        public final long numCols;
        public final long maxRowsInMemory;

        public Inputs(GraphOperation op) {
            super(new LoadAndRemapMatrix(op), op, Arrays.asList("num_rows", "num_cols", "max_rows_in_memory"));
            int inputIndex = 0;
            this.ckptPath = op.input(inputIndex++);
            this.oldTensorName = op.input(inputIndex++);
            this.rowRemapping = op.input(inputIndex++);
            this.colRemapping = op.input(inputIndex++);
            this.initializingValues = op.input(inputIndex++);
            this.numRows = op.attributes().getAttrInt("num_rows");
            this.numCols = op.attributes().getAttrInt("num_cols");
            this.maxRowsInMemory = op.attributes().getAttrInt("max_rows_in_memory");
        }
    }

    public static class Options {
        private Long maxRowsInMemory;

        private Options() {
        }

        public Options maxRowsInMemory(Long maxRowsInMemory) {
            this.maxRowsInMemory = maxRowsInMemory;
            return this;
        }
    }
}

