/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.BytesSupplier;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonSerializable;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ImageServingTranslator
implements Translator<Input, Output> {
    private Translator<Image, ?> translator;
    private ImageFactory factory;

    public ImageServingTranslator(Translator<Image, ?> translator) {
        this.translator = translator;
        this.factory = ImageFactory.getInstance();
    }

    @Override
    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        Output output = new Output();
        Object obj = this.translator.processOutput(ctx, list);
        if (obj instanceof JsonSerializable) {
            output.add((JsonSerializable)obj);
        } else {
            output.add(BytesSupplier.wrapAsJson(obj));
        }
        output.addProperty("Content-Type", "application/json");
        return output;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        BytesSupplier data = input.getData();
        try {
            if (data == null) {
                throw new TranslateException("Input data is empty.");
            }
            Image image = this.factory.fromInputStream(new ByteArrayInputStream(data.getAsBytes()));
            return this.translator.processInput(ctx, image);
        }
        catch (IOException e) {
            throw new TranslateException("Input is not an Image data type", e);
        }
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }
}

