/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.output;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.util.JsonUtils;
import com.google.gson.Gson;
import java.util.List;

public class DetectedObjects
extends Classifications {
    private static final long serialVersionUID = 1L;
    private static final Gson GSON = JsonUtils.builder().registerTypeAdapter(DetectedObjects.class, (Object)new Classifications.ClassificationsSerializer()).create();
    private List<BoundingBox> boundingBoxes;

    public DetectedObjects(List<String> classNames, List<Double> probabilities, List<BoundingBox> boundingBoxes) {
        super(classNames, probabilities);
        this.boundingBoxes = boundingBoxes;
    }

    @Override
    public <T extends Classifications.Classification> T item(int index) {
        return (T)new DetectedObject((String)this.classNames.get(index), (Double)this.probabilities.get(index), this.boundingBoxes.get(index));
    }

    public int getNumberOfObjects() {
        return this.boundingBoxes.size();
    }

    @Override
    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public static final class DetectedObject
    extends Classifications.Classification {
        private BoundingBox boundingBox;

        public DetectedObject(String className, double probability, BoundingBox boundingBox) {
            super(className, probability);
            this.boundingBox = boundingBox;
        }

        public BoundingBox getBoundingBox() {
            return this.boundingBox;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            if (this.getBoundingBox() != null) {
                sb.append(", bounds: ").append(this.getBoundingBox());
            }
            return sb.toString();
        }
    }
}

