// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>Create a horizontal rule. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#edef-HR">HR element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-align><CODE>&nbsp;align</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getAlign()'>getAlign</a>
<a href='#setAlign(java.lang.String)'>setAlign</a>
</TD>
<TD>
  <P>Align the rule on the page. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-align-HR">align attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-noShade><CODE>&nbsp;noShade</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNoShade()'>getNoShade</a>
<a href='#setNoShade(java.lang.String)'>setNoShade</a>
</TD>
<TD>
  <P>Indicates to the user agent that there should be no shading in the rendering of this element. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-noshade">noshade attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-size><CODE>&nbsp;size</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSize()'>getSize</a>
<a href='#setSize(java.lang.String)'>setSize</a>
</TD>
<TD>
  <P>The height of the rule. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-size-HR">size attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-width><CODE>&nbsp;width</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getWidth()'>getWidth</a>
<a href='#setWidth(java.lang.String)'>setWidth</a>
</TD>
<TD>
  <P>The width of the rule. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-width-HR">width attribute definition</A>
 in HTML 4.0. This attribute is deprecated in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLHRElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-align>align</a></code> property.
	 */
	void setAlign (String align);

	/**
	 * Returns the value of the <code><a href=#att-align>align</a></code> property.
	*/
	String getAlign ();


	/** Assigns the value of the <code><a href=#att-noShade>noShade</a></code> property.
	 */
	void setNoShade (boolean noShade);

	/**
	 * Returns the value of the <code><a href=#att-noShade>noShade</a></code> property.
	*/
	boolean getNoShade ();


	/** Assigns the value of the <code><a href=#att-size>size</a></code> property.
	 */
	void setSize (String size);

	/**
	 * Returns the value of the <code><a href=#att-size>size</a></code> property.
	*/
	String getSize ();


	/** Assigns the value of the <code><a href=#att-width>width</a></code> property.
	 */
	void setWidth (String width);

	/**
	 * Returns the value of the <code><a href=#att-width>width</a></code> property.
	*/
	String getWidth ();


}
