// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>An 
    <A HREF='HTMLCollection.html'><CODE>HTMLCollection</CODE></A> is a list of nodes. An individual node may be accessed by either ordinal index or the node's 
    <code>name</code> or 
    <code>id</code> attributes. 
    <emph>Note:</emph>
Collections in the HTML DOM are assumed to be 
    <emph>live</emph> meaning that they are automatically updated when the underlying document is changed. 
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-length><CODE>&nbsp;length</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getLength()'>getLength</a>
</TD>
<TD>
  <P>This attribute specifies the length or 
    <emph>size</emph> of the list. 
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLCollection
{
	/**
	 * Returns the value of the <code><a href=#att-length>length</a></code> property.
	*/
	int getLength ();


/**

  <P>This method retrieves a node specified by ordinal index. Nodes are numbered in tree order (depth-first traversal order).
</P>

@return The 
  <code>Node</code> at the corresponding position upon success. A value of 
  <code>null</code> is returned if the index is out of range. 

@param index
The index of the node to be fetched. The index origin is 0.
*/
Node item (int index);

/**

  <P>This method retrieves a 
    <code>Node</code> using a name. It first searches for a 
    <code>Node</code> with a matching 
    <code>id</code> attribute. If it doesn't find one, it then searches for a 
    <code>Node</code> with a matching 
    <code>name</code> attribute, but only on those elements that are allowed a name attribute. 
  
</P>

@return The 
  <code>Node</code> with a 
  <code>name</code> or 
  <code>id</code> attribute whose value corresponds to the specified string. Upon failure (e.g., no node with this name exists), returns 
  <code>null</code>.

@param name
The name of the 
  <code>Node</code> to be fetched.

*/
Node namedItem (String name);

}
