// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>Each <A HREF='Document.html'><CODE>Document</CODE></A> has a <code>doctype</code> attribute
        whose value is either <code>null</code> or a <A HREF='DocumentType.html'><CODE>DocumentType</CODE></A>
        object. The <A HREF='DocumentType.html'><CODE>DocumentType</CODE></A> interface in the DOM Level 1 Core
      provides an interface to the list of entities that are defined
      for the document, and little else because the effect of
      namespaces and the various XML scheme efforts on DTD
      representation are not clearly understood as of this writing.
<P>The DOM Level 1 doesn't support editing <A HREF='DocumentType.html'><CODE>DocumentType</CODE></A>
      nodes.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
</TD>
<TD><P>The name of DTD; i.e., the name immediately
	following the <code>DOCTYPE</code> keyword.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-entities><CODE>&nbsp;entities</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getEntities()'>getEntities</a>
</TD>
<TD><P>A <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> containing the general entities, both
	external and internal, declared in the DTD. Duplicates are discarded.
	For example in:
<CODE><PRE>&lt;!DOCTYPE ex SYSTEM "ex.dtd" [
  &lt;!ENTITY foo "foo"&gt;
  &lt;!ENTITY bar "bar"&gt;
  &lt;!ENTITY % baz "baz"&gt;
]&gt;
&lt;ex/&gt;</PRE></CODE>
  
	the interface provides access to <code>foo</code> and
	<code>bar</code> but not <code>baz</code>. Every node in this map
	also implements the <A HREF='Entity.html'><CODE>Entity</CODE></A> interface.
<P>The DOM Level 1 does not support editing entities, therefore
        <code>entities</code> cannot be altered in any way.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-notations><CODE>&nbsp;notations</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNotations()'>getNotations</a>
</TD>
<TD><P>A <A HREF='NamedNodeMap.html'><CODE>NamedNodeMap</CODE></A> containing  the
	notations declared in the DTD. Duplicates are discarded. Every node in
	this map also implements the <A HREF='Notation.html'><CODE>Notation</CODE></A> interface.
<P>The DOM Level 1 does not support editing notations, therefore
        <code>notations</code> cannot be altered in any way.
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface DocumentType
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/**
	 * Returns the value of the <code><a href=#att-entities>entities</a></code> property.
	*/
	NamedNodeMap getEntities ();


	/**
	 * Returns the value of the <code><a href=#att-notations>notations</a></code> property.
	*/
	NamedNodeMap getNotations ();


}
