// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>
The <A HREF='Attr.html'><CODE>Attr</CODE></A> interface represents an attribute in an <A HREF='Element.html'><CODE>Element</CODE></A> object.
Typically the allowable values for the attribute are defined in a document
type definition.
<P><A HREF='Attr.html'><CODE>Attr</CODE></A> objects inherit the <A HREF='Node.html'><CODE>Node</CODE></A> 
   interface, but since they are not actually child nodes of the element 
   they describe, the DOM does not consider them part of the document 
   tree.  Thus, the <A HREF='Node.html'><CODE>Node</CODE></A> attributes <code>parentNode</code>, 
   <code>previousSibling</code>, and <code>nextSibling</code> have a 
   null value for <A HREF='Attr.html'><CODE>Attr</CODE></A> objects. The DOM takes the 
   view that attributes are properties of elements rather than having a 
   separate identity from the elements they are associated with; 
   this should make it more efficient to implement
   such features as default attributes associated with all elements of a 
   given type.  Furthermore, <A HREF='Attr.html'><CODE>Attr</CODE></A>
   nodes may not be immediate children of a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A>.
   However, they can be associated with <A HREF='Element.html'><CODE>Element</CODE></A> nodes contained within
   a <A HREF='DocumentFragment.html'><CODE>DocumentFragment</CODE></A>.
   In short, users and implementors of the DOM need to be aware that 
   <A HREF='Attr.html'><CODE>Attr</CODE></A> nodes have some things in 
   common with other objects inheriting the <A HREF='Node.html'><CODE>Node</CODE></A> interface, 
   but they also are quite distinct.
<P> The attribute's effective value is determined as follows: if this 
   attribute has been explicitly assigned any value, that value is the 
   attribute's effective value; otherwise, if there is a declaration for 
   this attribute, and that declaration includes a default value, then 
   that default value is the attribute's effective value; otherwise, the 
   attribute does not exist on this element in the structure model until 
   it has been explicitly added.  Note that the <code>nodeValue</code> 
   attribute on the <A HREF='Attr.html'><CODE>Attr</CODE></A> instance can also be used to
   retrieve the string version of the attribute's value(s). 
<P>In XML, where the value of an attribute can contain entity references,
    the child nodes of the <A HREF='Attr.html'><CODE>Attr</CODE></A> node provide a representation in
    which entity references are not expanded. These child nodes may be either
    <A HREF='Text.html'><CODE>Text</CODE></A> or <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> nodes. Because the
    attribute type may be unknown, there are no tokenized attribute values.
    

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-name><CODE>&nbsp;name</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getName()'>getName</a>
</TD>
<TD><P>Returns the name of this attribute. 
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-specified><CODE>&nbsp;specified</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSpecified()'>getSpecified</a>
</TD>
<TD><P>If this attribute was explicitly given a value in the original
    document, this is <code>true</code>; otherwise, it is <code>false</code>.
    Note that the implementation is in charge of this attribute, not the
    user. If the user changes the value of the attribute (even if it ends up
    having the same value as the default value) then the <code>specified</code>
    flag is automatically flipped to <code>true</code>.  To re-specify the
    attribute as the default value from the DTD, the user must delete the
    attribute. The implementation will then make a new attribute available
    with <code>specified</code> set to <code>false</code> and the default value
    (if one exists).
<P>In summary:
<UL>
<LI><P> If the attribute has an assigned value in the document then  
    <code>specified</code> is <code>true</code>, and the value is the 
    assigned value.

</LI>
<LI><P> If the attribute has no assigned value in the document and has 
    a default value in the DTD, then  <code>specified</code> is <code>false</code>,  
    and the value is the default value in the DTD.
</LI>
<LI><P> If the attribute has no assigned value in the document and has 
    a value of #IMPLIED in the DTD, then the  attribute does not appear 
    in the structure model of the document.

</LI>
</UL>

</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-value><CODE>&nbsp;value</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getValue()'>getValue</a>
<a href='#setValue(java.lang.String)'>setValue</a>
</TD>
<TD><P>On retrieval, the value of the attribute is returned as a
	string. Character and general entity references are replaced with their
	values.
<P>On setting, this creates a <A HREF='Text.html'><CODE>Text</CODE></A> node with the unparsed
	contents of the string.
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Attr
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-name>name</a></code> property.
	*/
	String getName ();


	/**
	 * Returns the value of the <code><a href=#att-specified>specified</a></code> property.
	*/
	boolean getSpecified ();


	/** Assigns the value of the <code><a href=#att-value>value</a></code> property.
	 */
	void setValue (String value);

	/**
	 * Returns the value of the <code><a href=#att-value>value</a></code> property.
	*/
	String getValue ();


}
