/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.co.jemos.podam.api.ClassAttribute;
import uk.co.jemos.podam.api.ClassAttributeApprover;
import uk.co.jemos.podam.api.ClassInfo;
import uk.co.jemos.podam.api.ClassInfoStrategy;
import uk.co.jemos.podam.api.DefaultClassInfoStrategy;
import uk.co.jemos.podam.common.PodamExclude;

public abstract class AbstractClassInfoStrategy
implements ClassInfoStrategy,
ClassAttributeApprover {
    private final Pattern GETTER_PATTERN = this.getGetterPattern();
    private final Pattern SETTER_PATTERN = this.getSetterPattern();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClassInfoStrategy.class);
    private final Set<Class<? extends Annotation>> excludedAnnotations = new HashSet<Class<? extends Annotation>>();
    private Map<Class<?>, Set<String>> excludedFields = new HashMap();
    private final Map<Class<?>, List<Method>> extraMethods = new HashMap();

    public AbstractClassInfoStrategy addExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.add(annotation);
        return this;
    }

    public AbstractClassInfoStrategy addExtraMethod(Class<?> pojoClass, String methodName, Class<?> ... methodArgs) throws NoSuchMethodException, SecurityException {
        Method method = pojoClass.getMethod(methodName, methodArgs);
        List<Method> methods = this.extraMethods.get(pojoClass);
        if (methods == null) {
            methods = new ArrayList<Method>();
            this.extraMethods.put(pojoClass, methods);
        }
        methods.add(method);
        return this;
    }

    public AbstractClassInfoStrategy removeExcludedAnnotation(Class<? extends Annotation> annotation) {
        this.excludedAnnotations.remove(annotation);
        return this;
    }

    public AbstractClassInfoStrategy addExcludedField(Class<?> pojoClass, String fieldName) {
        Set<String> fields = this.excludedFields.get(pojoClass);
        if (fields == null) {
            fields = new HashSet<String>();
            this.excludedFields.put(pojoClass, fields);
        }
        fields.add(fieldName);
        return this;
    }

    public AbstractClassInfoStrategy removeExcludedField(Class<?> pojoClass, String fieldName) {
        Set<String> fields = this.excludedFields.get(pojoClass);
        if (fields != null) {
            fields.remove(fieldName);
        }
        return this;
    }

    @Override
    public boolean approve(ClassAttribute attribute) {
        if (attribute.getRawSetters().size() > 1) {
            for (Method setter : attribute.getRawSetters()) {
                if (setter.getParameterTypes().length <= 1) continue;
                return false;
            }
        }
        return attribute.getAttribute() != null;
    }

    @Override
    public Set<Class<? extends Annotation>> getExcludedAnnotations() {
        return this.excludedAnnotations;
    }

    @Override
    public Set<String> getExcludedFields(Class<?> pojoClass) {
        return this.excludedFields.get(pojoClass);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> pojoClass) {
        List<Method> localExtraMethods;
        Set<String> excludedAttributes = this.excludedFields.get(pojoClass);
        if (null == excludedAttributes) {
            excludedAttributes = Collections.emptySet();
        }
        if (null == (localExtraMethods = this.extraMethods.get(pojoClass))) {
            localExtraMethods = Collections.emptyList();
        }
        return this.getClassInfo(pojoClass, this.excludedAnnotations, excludedAttributes, this, localExtraMethods);
    }

    @Override
    public ClassAttributeApprover getClassAttributeApprover(Class<?> pojoClass) {
        return this;
    }

    @Override
    public Collection<Method> getExtraMethods(Class<?> pojoClass) {
        return this.extraMethods.get(pojoClass);
    }

    public ClassInfo getClassInfo(Class<?> clazz, Set<Class<? extends Annotation>> excludeFieldAnnotations, Set<String> excludedFields, ClassAttributeApprover attributeApprover, Collection<Method> extraMethods) {
        if (null == attributeApprover) {
            attributeApprover = DefaultClassInfoStrategy.getInstance().getClassAttributeApprover(clazz);
        }
        TreeMap<String, ClassAttribute> attributeMap = new TreeMap<String, ClassAttribute>();
        this.findPojoAttributes(clazz, attributeMap, excludeFieldAnnotations, excludedFields);
        ArrayList<ClassAttribute> attributes = new ArrayList<ClassAttribute>(attributeMap.values());
        Iterator iter = attributes.iterator();
        block0: while (iter.hasNext()) {
            ClassAttribute attribute = (ClassAttribute)iter.next();
            Field field = attribute.getAttribute();
            if (excludedFields.contains(attribute.getName()) || field != null && this.containsAnyAnnotation(field, excludeFieldAnnotations)) {
                iter.remove();
                continue;
            }
            for (Method classGetter : attribute.getRawGetters()) {
                if (!this.containsAnyAnnotation(classGetter, excludeFieldAnnotations)) continue;
                iter.remove();
                continue block0;
            }
            for (Method classSetter : attribute.getRawSetters()) {
                if (!this.containsAnyAnnotation(classSetter, excludeFieldAnnotations)) continue;
                iter.remove();
                continue block0;
            }
            if (attributeApprover.approve(attribute)) continue;
            iter.remove();
        }
        return new ClassInfo(clazz, attributes, extraMethods);
    }

    private boolean containsAnyAnnotation(Method method, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (method.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyAnnotation(Field field, Set<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (field.getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    protected void findPojoAttributes(Class<?> clazz, Map<String, ClassAttribute> attributeMap, Set<Class<? extends Annotation>> excludeAnnotations, Set<String> excludedFields) {
        if (excludeAnnotations == null) {
            excludeAnnotations = new HashSet<Class<? extends Annotation>>();
        }
        excludeAnnotations.add(PodamExclude.class);
        Class<?> workClass = clazz;
        while (!Object.class.equals(workClass)) {
            Method[] declaredMethods = workClass.getDeclaredMethods();
            Field[] declaredFields = workClass.getDeclaredFields();
            for (Field field : declaredFields) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                String attributeName = field.getName();
                ClassAttribute attribute = attributeMap.get(attributeName);
                if (attribute != null) {
                    if (attribute.getAttribute() != null) continue;
                    attribute.setAttribute(field);
                    continue;
                }
                attribute = new ClassAttribute(field.getName(), field, Collections.emptySet(), Collections.emptySet());
                attributeMap.put(field.getName(), attribute);
            }
            for (AccessibleObject accessibleObject : declaredMethods) {
                Pattern pattern;
                if (((Method)accessibleObject).isBridge() || Modifier.isNative(((Method)accessibleObject).getModifiers())) continue;
                if (((Method)accessibleObject).getParameterTypes().length == 0 && !((Method)accessibleObject).getReturnType().equals(Void.TYPE)) {
                    pattern = this.GETTER_PATTERN;
                } else {
                    if (((Method)accessibleObject).getParameterTypes().length <= 0 || !((Method)accessibleObject).getReturnType().equals(Void.TYPE) && !((Method)accessibleObject).getReturnType().isAssignableFrom(workClass)) continue;
                    pattern = this.SETTER_PATTERN;
                }
                String methodName = ((Method)accessibleObject).getName();
                String attributeName = this.extractFieldNameFromMethod(methodName, pattern);
                if (attributeName.equals(methodName)) continue;
                if (!attributeName.isEmpty()) {
                    ClassAttribute attribute = attributeMap.get(attributeName);
                    if (attribute == null) {
                        attribute = new ClassAttribute(attributeName, null, Collections.emptySet(), Collections.emptySet());
                        attributeMap.put(attributeName, attribute);
                    }
                    Set<Method> accessors = pattern == this.GETTER_PATTERN ? attribute.getRawGetters() : attribute.getRawSetters();
                    accessors.add((Method)accessibleObject);
                    continue;
                }
                LOG.debug("Encountered accessor {}. This will be ignored.", (Object)accessibleObject);
            }
            workClass = workClass.getSuperclass();
        }
    }

    protected String extractFieldNameFromMethod(String methodName, Pattern pattern) {
        String candidateFieldEnding;
        String candidateField = pattern.matcher(methodName).replaceFirst("");
        if (!(candidateField.isEmpty() || candidateField.equals(methodName) || !(candidateFieldEnding = candidateField.substring(1)).isEmpty() && candidateFieldEnding.toUpperCase().equals(candidateFieldEnding) && !candidateFieldEnding.toLowerCase().equals(candidateFieldEnding.toUpperCase()))) {
            candidateField = Character.toLowerCase(candidateField.charAt(0)) + candidateFieldEnding;
        }
        return candidateField;
    }

    protected Pattern getGetterPattern() {
        return Pattern.compile("^(get|is)");
    }

    protected Pattern getSetterPattern() {
        return Pattern.compile("^set");
    }
}

