/*
 * Decompiled with CFR 0.152.
 */
package top.tangyh.basic.database.config;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import lombok.Generated;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.tangyh.basic.base.entity.Entity;
import top.tangyh.basic.base.entity.SuperEntity;
import top.tangyh.basic.context.ContextUtil;
import top.tangyh.basic.utils.SpringUtils;

public class LampMetaObjectHandler
implements MetaObjectHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LampMetaObjectHandler.class);
    private UidGenerator uidGenerator;

    public void insertFill(MetaObject metaObject) {
        this.fillCreated(metaObject);
        this.fillUpdated(metaObject);
        this.fillId(metaObject);
    }

    private void fillId(MetaObject metaObject) {
        Object object;
        if (this.uidGenerator == null) {
            this.uidGenerator = (UidGenerator)SpringUtils.getBean(UidGenerator.class);
        }
        if ((object = metaObject.getOriginalObject()) instanceof SuperEntity) {
            SuperEntity superEntity = (SuperEntity)object;
            Object oldId = superEntity.getId();
            if (oldId != null) {
                return;
            }
            Long id = this.uidGenerator.getUid();
            Object idVal = "java.lang.String".equals(metaObject.getGetterType("id").getName()) ? String.valueOf(id) : id;
            this.setFieldValByName("id", idVal, metaObject);
            return;
        }
        if (metaObject.hasGetter("id")) {
            Object oldId = metaObject.getValue("id");
            if (oldId != null) {
                return;
            }
            Long id = this.uidGenerator.getUid();
            Object idVal = "java.lang.String".equals(metaObject.getGetterType("id").getName()) ? String.valueOf(id) : id;
            this.setFieldValByName("id", idVal, metaObject);
            return;
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(metaObject.getOriginalObject().getClass());
        if (tableInfo == null) {
            return;
        }
        Class keyType = tableInfo.getKeyType();
        if (keyType == null) {
            return;
        }
        String keyProperty = tableInfo.getKeyProperty();
        Object oldId = metaObject.getValue(keyProperty);
        if (oldId != null) {
            return;
        }
        Field idField = ReflectUtil.getField(metaObject.getOriginalObject().getClass(), (String)keyProperty);
        Object fieldValue = ReflectUtil.getFieldValue((Object)metaObject.getOriginalObject(), (Field)idField);
        if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
            return;
        }
        Long id = this.uidGenerator.getUid();
        Object idVal = keyType.getName().equalsIgnoreCase("java.lang.String") ? String.valueOf(id) : id;
        this.setFieldValByName(keyProperty, idVal, metaObject);
    }

    private void fillCreated(MetaObject metaObject) {
        Object oldVal;
        if (metaObject.getOriginalObject() instanceof SuperEntity) {
            this.created(metaObject);
            return;
        }
        if (metaObject.hasGetter("createdBy") && (oldVal = metaObject.getValue("createdBy")) == null) {
            this.setFieldValByName("createdBy", ContextUtil.getUserId(), metaObject);
        }
        if (metaObject.hasGetter("createdTime") && (oldVal = metaObject.getValue("createdTime")) == null) {
            this.setFieldValByName("createdTime", LocalDateTime.now(), metaObject);
        }
    }

    private void created(MetaObject metaObject) {
        SuperEntity entity = (SuperEntity)metaObject.getOriginalObject();
        if (entity.getCreatedTime() == null) {
            this.setFieldValByName("createdTime", LocalDateTime.now(), metaObject);
        }
        if (entity.getCreatedBy() == null || entity.getCreatedBy().equals(0)) {
            Object userIdVal = "java.lang.String".equals(metaObject.getGetterType("createdBy").getName()) ? String.valueOf(ContextUtil.getUserId()) : ContextUtil.getUserId();
            this.setFieldValByName("createdBy", userIdVal, metaObject);
        }
    }

    private void fillUpdated(MetaObject metaObject) {
        Object oldVal;
        if (metaObject.getOriginalObject() instanceof Entity) {
            this.update(metaObject);
            return;
        }
        if (metaObject.hasGetter("updatedBy") && (oldVal = metaObject.getValue("updatedBy")) == null) {
            this.setFieldValByName("updatedBy", ContextUtil.getUserId(), metaObject);
        }
        if (metaObject.hasGetter("updatedTime") && (oldVal = metaObject.getValue("updatedTime")) == null) {
            this.setFieldValByName("updatedTime", LocalDateTime.now(), metaObject);
        }
    }

    private void update(MetaObject metaObject) {
        Entity entity = (Entity)metaObject.getOriginalObject();
        if (entity.getUpdatedBy() == null || entity.getUpdatedBy().equals(0)) {
            Object userIdVal = "java.lang.String".equals(metaObject.getGetterType("updatedBy").getName()) ? String.valueOf(ContextUtil.getUserId()) : ContextUtil.getUserId();
            this.setFieldValByName("updatedBy", userIdVal, metaObject);
        }
        if (entity.getUpdatedTime() == null) {
            this.setFieldValByName("updatedTime", LocalDateTime.now(), metaObject);
        }
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("start update fill ....");
        this.fillUpdated(metaObject);
    }
}

