/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.customendpoint;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.RdsClientBuilder;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.authentication.AwsCredentialsManager;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointMonitor;
import software.amazon.jdbc.plugin.customendpoint.CustomEndpointMonitorImpl;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RdsUtils;
import software.amazon.jdbc.util.RegionUtils;
import software.amazon.jdbc.util.SlidingExpirationCacheWithCleanupThread;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.SubscribedMethodHelper;
import software.amazon.jdbc.util.WrapperUtils;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;

public class CustomEndpointPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(CustomEndpointPlugin.class.getName());
    private static final String TELEMETRY_WAIT_FOR_INFO_COUNTER = "customEndpoint.waitForInfo.counter";
    protected static final long CACHE_CLEANUP_RATE_NANO = TimeUnit.MINUTES.toNanos(1L);
    protected static final RegionUtils regionUtils = new RegionUtils();
    protected static final SlidingExpirationCacheWithCleanupThread<String, CustomEndpointMonitor> monitors = new SlidingExpirationCacheWithCleanupThread(CustomEndpointMonitor::shouldDispose, monitor -> {
        try {
            monitor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }, CACHE_CLEANUP_RATE_NANO);
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.addAll(SubscribedMethodHelper.NETWORK_BOUND_METHODS);
            this.add("connect");
        }
    });
    public static final AwsWrapperProperty CUSTOM_ENDPOINT_INFO_REFRESH_RATE_MS = new AwsWrapperProperty("customEndpointInfoRefreshRateMs", "30000", "Controls how frequently custom endpoint monitors fetch custom endpoint info, in milliseconds.");
    public static final AwsWrapperProperty WAIT_FOR_CUSTOM_ENDPOINT_INFO = new AwsWrapperProperty("waitForCustomEndpointInfo", "true", "Controls whether to wait for custom endpoint info to become available before connecting or executing a method. Waiting is only necessary if a connection to a given custom endpoint has not been opened or used recently. Note that disabling this may result in occasional connections to instances outside of the custom endpoint.");
    public static final AwsWrapperProperty WAIT_FOR_CUSTOM_ENDPOINT_INFO_TIMEOUT_MS = new AwsWrapperProperty("waitForCustomEndpointInfoTimeoutMs", "5000", "Controls the maximum amount of time that the plugin will wait for custom endpoint info to be made available by the custom endpoint monitor, in milliseconds.");
    public static final AwsWrapperProperty CUSTOM_ENDPOINT_MONITOR_IDLE_EXPIRATION_MS = new AwsWrapperProperty("customEndpointMonitorExpirationMs", String.valueOf(TimeUnit.MINUTES.toMillis(15L)), "Controls how long a monitor should run without use before expiring and being removed, in milliseconds.");
    public static final AwsWrapperProperty REGION_PROPERTY = new AwsWrapperProperty("customEndpointRegion", null, "The region of the cluster's custom endpoints. If not specified, the region will be parsed from the URL.");
    protected final PluginService pluginService;
    protected final Properties props;
    protected final RdsUtils rdsUtils = new RdsUtils();
    protected final BiFunction<HostSpec, Region, RdsClient> rdsClientFunc;
    protected final TelemetryCounter waitForInfoCounter;
    protected final boolean shouldWaitForInfo;
    protected final int waitOnCachedInfoDurationMs;
    protected final int idleMonitorExpirationMs;
    protected HostSpec customEndpointHostSpec;
    protected String customEndpointId;
    protected Region region;

    public CustomEndpointPlugin(PluginService pluginService, Properties props) {
        this(pluginService, props, (hostSpec, region) -> (RdsClient)((RdsClientBuilder)((RdsClientBuilder)RdsClient.builder().region(region)).credentialsProvider(AwsCredentialsManager.getProvider(hostSpec, props))).build());
    }

    public CustomEndpointPlugin(PluginService pluginService, Properties props, BiFunction<HostSpec, Region, RdsClient> rdsClientFunc) {
        this.pluginService = pluginService;
        this.props = props;
        this.rdsClientFunc = rdsClientFunc;
        this.shouldWaitForInfo = WAIT_FOR_CUSTOM_ENDPOINT_INFO.getBoolean(this.props);
        this.waitOnCachedInfoDurationMs = WAIT_FOR_CUSTOM_ENDPOINT_INFO_TIMEOUT_MS.getInteger(this.props);
        this.idleMonitorExpirationMs = CUSTOM_ENDPOINT_MONITOR_IDLE_EXPIRATION_MS.getInteger(this.props);
        TelemetryFactory telemetryFactory = pluginService.getTelemetryFactory();
        this.waitForInfoCounter = telemetryFactory.createCounter(TELEMETRY_WAIT_FOR_INFO_COUNTER);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        if (!this.rdsUtils.isRdsCustomClusterDns(hostSpec.getHost())) {
            return connectFunc.call();
        }
        this.customEndpointHostSpec = hostSpec;
        LOGGER.finest(Messages.get("CustomEndpointPlugin.connectionRequestToCustomEndpoint", new Object[]{hostSpec.getHost()}));
        this.customEndpointId = this.rdsUtils.getRdsClusterId(this.customEndpointHostSpec.getHost());
        if (StringUtils.isNullOrEmpty(this.customEndpointId)) {
            throw new SQLException(Messages.get("CustomEndpointPlugin.errorParsingEndpointIdentifier", new Object[]{this.customEndpointHostSpec.getHost()}));
        }
        this.region = regionUtils.getRegion(this.customEndpointHostSpec.getHost(), props, CustomEndpointPlugin.REGION_PROPERTY.name);
        if (this.region == null) {
            throw new SQLException(Messages.get("CustomEndpointPlugin.unableToDetermineRegion", new Object[]{CustomEndpointPlugin.REGION_PROPERTY.name}));
        }
        CustomEndpointMonitor monitor = this.createMonitorIfAbsent(props);
        if (this.shouldWaitForInfo) {
            this.waitForCustomEndpointInfo(monitor);
        }
        return connectFunc.call();
    }

    protected CustomEndpointMonitor createMonitorIfAbsent(Properties props) {
        return monitors.computeIfAbsent(this.customEndpointHostSpec.getHost(), customEndpoint -> new CustomEndpointMonitorImpl(this.pluginService, this.customEndpointHostSpec, this.customEndpointId, this.region, TimeUnit.MILLISECONDS.toNanos(CUSTOM_ENDPOINT_INFO_REFRESH_RATE_MS.getLong(props)), this.rdsClientFunc), TimeUnit.MILLISECONDS.toNanos(this.idleMonitorExpirationMs));
    }

    protected void waitForCustomEndpointInfo(CustomEndpointMonitor monitor) throws SQLException {
        boolean hasCustomEndpointInfo = monitor.hasCustomEndpointInfo();
        if (!hasCustomEndpointInfo) {
            this.waitForInfoCounter.inc();
            LOGGER.fine(Messages.get("CustomEndpointPlugin.waitingForCustomEndpointInfo", new Object[]{this.customEndpointHostSpec.getHost(), this.waitOnCachedInfoDurationMs}));
            long waitForEndpointInfoTimeoutNano = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.waitOnCachedInfoDurationMs);
            try {
                while (!hasCustomEndpointInfo && System.nanoTime() < waitForEndpointInfoTimeoutNano) {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    hasCustomEndpointInfo = monitor.hasCustomEndpointInfo();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SQLException(Messages.get("CustomEndpointPlugin.interruptedThread", new Object[]{this.customEndpointHostSpec.getHost()}));
            }
            if (!hasCustomEndpointInfo) {
                throw new SQLException(Messages.get("CustomEndpointPlugin.timedOutWaitingForCustomEndpointInfo", new Object[]{this.waitOnCachedInfoDurationMs, this.customEndpointHostSpec.getHost()}));
            }
        }
    }

    @Override
    public <T, E extends Exception> T execute(Class<T> resultClass, Class<E> exceptionClass, Object methodInvokeOn, String methodName, JdbcCallable<T, E> jdbcMethodFunc, Object[] jdbcMethodArgs) throws E {
        if (this.customEndpointHostSpec == null) {
            return jdbcMethodFunc.call();
        }
        try {
            CustomEndpointMonitor monitor = this.createMonitorIfAbsent(this.props);
            if (this.shouldWaitForInfo) {
                this.waitForCustomEndpointInfo(monitor);
            }
        }
        catch (Exception e) {
            throw WrapperUtils.wrapExceptionIfNeeded(exceptionClass, e);
        }
        return jdbcMethodFunc.call();
    }

    public static void closeMonitors() {
        LOGGER.info(Messages.get("CustomEndpointPlugin.closeMonitors"));
        monitors.clear();
    }

    static {
        PropertyDefinition.registerPluginProperties(CustomEndpointPlugin.class);
    }
}

