/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.xml.parsing;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.Strings;
import org.zwobble.mammoth.internal.xml.NamespacePrefixes;
import org.zwobble.mammoth.internal.xml.XmlElement;
import org.zwobble.mammoth.internal.xml.XmlTextNode;
import org.zwobble.mammoth.internal.xml.parsing.ElementName;
import org.zwobble.mammoth.internal.xml.parsing.SimpleSax;
import org.zwobble.mammoth.internal.xml.parsing.SimpleSaxHandler;
import org.zwobble.mammoth.internal.xml.parsing.XmlElementBuilder;

public class XmlParser {
    private final NamespacePrefixes namespaces;

    public XmlParser(NamespacePrefixes namespaces) {
        this.namespaces = namespaces;
    }

    public XmlElement parseStream(InputStream inputStream) {
        NodeGenerator nodeGenerator = new NodeGenerator();
        SimpleSax.parseStream(inputStream, nodeGenerator);
        return nodeGenerator.getRoot();
    }

    public XmlElement parseString(String value) {
        NodeGenerator nodeGenerator = new NodeGenerator();
        SimpleSax.parseString(value, nodeGenerator);
        return nodeGenerator.getRoot();
    }

    private class NodeGenerator
    implements SimpleSaxHandler {
        private final Deque<XmlElementBuilder> elementStack = new ArrayDeque<XmlElementBuilder>();

        public XmlElement getRoot() {
            return this.elementStack.getFirst().build();
        }

        @Override
        public void startElement(ElementName name, Map<ElementName, String> attributes) {
            Map<String, String> simpleAttributes = Maps.eagerMapKeys(attributes, this::readName);
            XmlElementBuilder element = new XmlElementBuilder(this.readName(name), simpleAttributes);
            this.elementStack.add(element);
        }

        private String readName(ElementName name) {
            if (Strings.isNullOrEmpty(name.getUri())) {
                return name.getLocalName();
            }
            return XmlParser.this.namespaces.lookupUri(name.getUri()).map(namespace -> namespace.getPrefix().map(prefix -> prefix + ":").orElse("") + name.getLocalName()).orElseGet(() -> "{" + name.getUri() + "}" + name.getLocalName());
        }

        @Override
        public void endElement() {
            if (this.elementStack.size() > 1) {
                XmlElementBuilder element = this.elementStack.removeLast();
                this.elementStack.getLast().addChild(element.build());
            }
        }

        @Override
        public void characters(String string) {
            this.elementStack.getLast().addChild(new XmlTextNode(string));
        }
    }
}

