/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.util;

import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Iterables {
    public static <T> Optional<T> tryFind(Iterable<T> iterable, Predicate<T> predicate) {
        for (T element : iterable) {
            if (!predicate.test(element)) continue;
            return Optional.of(element);
        }
        return Optional.empty();
    }

    public static <T, R> Iterable<R> lazyMap(final Iterable<T> iterable, final Function<T, R> function) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return Iterables.map(iterable.iterator(), function);
            }
        };
    }

    public static <T, R> Iterable<R> lazyMapWithIndex(final Iterable<T> iterable, final BiFunction<Integer, T, R> function) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return Iterables.map(iterable.iterator(), function);
            }
        };
    }

    public static <T> Optional<T> getFirst(Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public static <T> T getFirst(Iterable<? extends T> iterable, T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return defaultValue;
    }

    public static <T> Optional<T> tryGetLast(Iterable<? extends T> iterable) {
        T last;
        Iterator<T> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        do {
            last = iterator.next();
        } while (iterator.hasNext());
        return Optional.of(last);
    }

    public static <T, R> Iterable<R> lazyFlatMap(Iterable<T> iterable, Function<T, Iterable<R>> function) {
        return Iterables.lazyFlatten(Iterables.lazyMap(iterable, function));
    }

    public static <T> Iterable<T> lazyConcat(final Iterable<T> iterable1, final Iterable<T> iterable2) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Stream.concat(Iterables.stream(iterable1), Iterables.stream(iterable2)).iterator();
            }
        };
    }

    public static <T> Iterable<T> lazyFlatten(final Iterable<? extends Iterable<T>> iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterables.stream(iterables).flatMap(iterable -> Iterables.stream(iterable)).iterator();
            }
        };
    }

    public static <T> Iterable<T> lazyFilter(final Iterable<T> iterables, final Predicate<T> predicate) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterables.stream(iterables).filter(predicate).iterator();
            }
        };
    }

    public static <T, R> Iterable<R> lazyFilter(final Iterable<T> iterables, final Class<R> clazz) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return Iterables.stream(iterables).filter(clazz::isInstance).iterator();
            }
        };
    }

    private static <T, R> Iterator<R> map(final Iterator<T> iterator, final Function<T, R> function) {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return function.apply(iterator.next());
            }
        };
    }

    private static <T, R> Iterator<R> map(final Iterator<T> iterator, final BiFunction<Integer, T, R> function) {
        return new Iterator<R>(){
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public R next() {
                return function.apply(this.nextIndex++, iterator.next());
            }
        };
    }

    public static <T> boolean any(Iterable<T> iterable, Predicate<T> predicate) {
        return Iterables.stream(iterable).anyMatch(predicate);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> OptionalInt findIndex(Iterable<T> iterable, Predicate<T> predicate) {
        int index = 0;
        for (T element : iterable) {
            if (predicate.test(element)) {
                return OptionalInt.of(index);
            }
            ++index;
        }
        return OptionalInt.empty();
    }

    public static Iterable<Integer> intRange(final int start, final int end) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int next;
                    {
                        this.next = start;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next < end;
                    }

                    @Override
                    public Integer next() {
                        return this.next++;
                    }
                };
            }
        };
    }
}

