/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.List;
import org.zwobble.mammoth.internal.styles.parsing.LineParseException;
import org.zwobble.mammoth.internal.styles.parsing.Token;

public class TokenIterator<T> {
    private final List<Token<T>> tokens;
    private final Token<T> end;
    private int index;

    public TokenIterator(List<Token<T>> tokens, Token<T> end) {
        this.tokens = tokens;
        this.end = end;
        this.index = 0;
    }

    public boolean isNext(int offset, T tokenType, String value) {
        int tokenIndex = this.index + offset;
        Token<T> token = this.getToken(tokenIndex);
        return token.getTokenType().equals(tokenType) && token.getValue().equals(value);
    }

    public boolean isNext(T tokenType, String value) {
        return this.isNext(0, tokenType, value);
    }

    public boolean trySkip(T tokenType, String value) {
        if (this.isNext(tokenType, value)) {
            this.skip();
            return true;
        }
        return false;
    }

    public T peekTokenType() {
        return this.getToken(this.index).getTokenType();
    }

    public Token<T> next() {
        Token<T> token = this.getToken(this.index);
        ++this.index;
        return token;
    }

    public Token<T> next(T type) {
        Token<T> token = this.getToken(this.index);
        if (token.getTokenType().equals(type)) {
            ++this.index;
            return token;
        }
        throw this.unexpectedTokenType(type, token);
    }

    public String nextValue(T type) {
        return this.next(type).getValue();
    }

    public void skip() {
        ++this.index;
    }

    public void skip(T tokenType) {
        Token<T> token = this.getToken(this.index);
        if (!token.getTokenType().equals(tokenType)) {
            throw this.unexpectedTokenType(tokenType, token);
        }
        ++this.index;
    }

    public void skip(T tokenType, String tokenValue) {
        Token<T> token = this.getToken(this.index);
        if (!token.getTokenType().equals(tokenType)) {
            throw this.unexpectedTokenType(tokenType, token);
        }
        String actualValue = token.getValue();
        if (!actualValue.equals(tokenValue)) {
            throw LineParseException.lineParseException(token, "expected " + tokenType + " token with value " + tokenValue + " but value was " + actualValue);
        }
        ++this.index;
    }

    private LineParseException unexpectedTokenType(T expected, Token<T> actual) {
        return LineParseException.lineParseException(actual, "expected token of type " + expected + " but was of type " + actual.getTokenType());
    }

    public boolean tryParse(Action action) {
        int originalIndex = this.index;
        try {
            action.run();
            return true;
        }
        catch (LineParseException exception) {
            this.index = originalIndex;
            return false;
        }
    }

    private Token<T> getToken(int index) {
        if (index < this.tokens.size()) {
            return this.tokens.get(index);
        }
        return this.end;
    }

    public static interface Action {
        public void run();
    }
}

