/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.List;
import org.zwobble.mammoth.internal.styles.parsing.RegexTokeniser;
import org.zwobble.mammoth.internal.styles.parsing.Token;
import org.zwobble.mammoth.internal.styles.parsing.TokenIterator;
import org.zwobble.mammoth.internal.styles.parsing.TokenType;
import org.zwobble.mammoth.internal.util.Lists;

public class StyleMappingTokeniser {
    public static TokenIterator<TokenType> tokenise(String line) {
        return new TokenIterator<TokenType>(StyleMappingTokeniser.tokeniseToList(line), new Token<TokenType>(line.length(), TokenType.EOF, ""));
    }

    public static List<Token<TokenType>> tokeniseToList(String line) {
        String stringPrefix = "'(?:(?:\\\\.|[^'])*)";
        String identifierCharacter = "(?:[a-zA-Z\\-_]|\\\\.)";
        RegexTokeniser<TokenType> tokeniser = new RegexTokeniser<TokenType>(TokenType.UNKNOWN, Lists.list(RegexTokeniser.rule(TokenType.IDENTIFIER, identifierCharacter + "(?:" + identifierCharacter + "|[0-9])*"), RegexTokeniser.rule(TokenType.SYMBOL, ":|>|=>|\\^=|=|\\(|\\)|\\[|\\]|\\||!|\\."), RegexTokeniser.rule(TokenType.WHITESPACE, "\\s+"), RegexTokeniser.rule(TokenType.STRING, stringPrefix + "'"), RegexTokeniser.rule(TokenType.UNTERMINATED_STRING, stringPrefix), RegexTokeniser.rule(TokenType.INTEGER, "[0-9]+")));
        return tokeniser.tokenise(line);
    }
}

