/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zwobble.mammoth.internal.styles.parsing.Token;
import org.zwobble.mammoth.internal.util.Iterables;
import org.zwobble.mammoth.internal.util.Lists;

public class RegexTokeniser<T> {
    private final Pattern pattern;
    private final List<T> rules;

    public static <T> TokenRule<T> rule(T type, String regex) {
        return new TokenRule<T>(type, Pattern.compile(regex));
    }

    public RegexTokeniser(T unknown, List<TokenRule<T>> rules) {
        ArrayList<TokenRule<T>> allRules = new ArrayList<TokenRule<T>>(rules);
        allRules.add(RegexTokeniser.rule(unknown, "."));
        this.pattern = Pattern.compile(String.join((CharSequence)"|", Iterables.lazyMap(allRules, rule -> "(" + ((TokenRule)rule).regex.pattern() + ")")));
        this.rules = Lists.eagerMap(allRules, rule -> ((TokenRule)rule).type);
    }

    public List<Token<T>> tokenise(String value) {
        Matcher matcher = this.pattern.matcher(value);
        ArrayList<Token<T>> tokens = new ArrayList<Token<T>>();
        while (matcher.lookingAt()) {
            Optional<Integer> groupIndex = Iterables.tryFind(Iterables.intRange(0, this.rules.size()), index -> !Objects.isNull(matcher.group(index + 1)));
            if (groupIndex.isPresent()) {
                T tokenType = this.rules.get(groupIndex.get());
                tokens.add(new Token<T>(matcher.regionStart(), tokenType, matcher.group()));
                matcher.region(matcher.end(), value.length());
                continue;
            }
            throw new RuntimeException("Could not find group");
        }
        return tokens;
    }

    public static class TokenRule<T> {
        private final T type;
        private final Pattern regex;

        public TokenRule(T type, Pattern regex) {
            if (regex.matcher("").groupCount() != 0) {
                throw new RuntimeException("regex cannot contain any groups");
            }
            this.type = type;
            this.regex = regex;
        }
    }
}

