/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles.parsing;

import java.math.BigInteger;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.styles.BreakMatcher;
import org.zwobble.mammoth.internal.styles.EqualToStringMatcher;
import org.zwobble.mammoth.internal.styles.HighlightMatcher;
import org.zwobble.mammoth.internal.styles.HtmlPath;
import org.zwobble.mammoth.internal.styles.ParagraphMatcher;
import org.zwobble.mammoth.internal.styles.RunMatcher;
import org.zwobble.mammoth.internal.styles.StartsWithStringMatcher;
import org.zwobble.mammoth.internal.styles.StringMatcher;
import org.zwobble.mammoth.internal.styles.StyleMapBuilder;
import org.zwobble.mammoth.internal.styles.TableMatcher;
import org.zwobble.mammoth.internal.styles.parsing.LineParseException;
import org.zwobble.mammoth.internal.styles.parsing.Token;
import org.zwobble.mammoth.internal.styles.parsing.TokenIterator;
import org.zwobble.mammoth.internal.styles.parsing.TokenParser;
import org.zwobble.mammoth.internal.styles.parsing.TokenType;

public class DocumentMatcherParser {
    public static BiConsumer<StyleMapBuilder, HtmlPath> parse(TokenIterator<TokenType> tokens) {
        Token<TokenType> identifier = tokens.next(TokenType.IDENTIFIER);
        switch (identifier.getValue()) {
            case "p": {
                ParagraphMatcher paragraph = DocumentMatcherParser.parseParagraphMatcher(tokens);
                return (builder, path) -> builder.mapParagraph(paragraph, (HtmlPath)path);
            }
            case "r": {
                RunMatcher run = DocumentMatcherParser.parseRunMatcher(tokens);
                return (builder, path) -> builder.mapRun(run, (HtmlPath)path);
            }
            case "table": {
                TableMatcher table = DocumentMatcherParser.parseTableMatcher(tokens);
                return (builder, path) -> builder.mapTable(table, (HtmlPath)path);
            }
            case "b": {
                return StyleMapBuilder::bold;
            }
            case "i": {
                return StyleMapBuilder::italic;
            }
            case "u": {
                return StyleMapBuilder::underline;
            }
            case "strike": {
                return StyleMapBuilder::strikethrough;
            }
            case "all-caps": {
                return StyleMapBuilder::allCaps;
            }
            case "small-caps": {
                return StyleMapBuilder::smallCaps;
            }
            case "highlight": {
                HighlightMatcher highlight = DocumentMatcherParser.parseHighlightMatcher(tokens);
                return (builder, path) -> builder.mapHighlight(highlight, (HtmlPath)path);
            }
            case "comment-reference": {
                return StyleMapBuilder::commentReference;
            }
            case "br": {
                BreakMatcher breakMatcher = DocumentMatcherParser.parseBreakMatcher(tokens);
                return (builder, path) -> builder.mapBreak(breakMatcher, (HtmlPath)path);
            }
        }
        throw LineParseException.lineParseException(identifier, "Unrecognised document element: " + identifier);
    }

    private static ParagraphMatcher parseParagraphMatcher(TokenIterator<TokenType> tokens) {
        Optional<String> styleId = DocumentMatcherParser.parseStyleId(tokens);
        Optional<StringMatcher> styleName = DocumentMatcherParser.parseStyleName(tokens);
        Optional<NumberingLevel> numbering = DocumentMatcherParser.parseNumbering(tokens);
        return new ParagraphMatcher(styleId, styleName, numbering);
    }

    private static RunMatcher parseRunMatcher(TokenIterator<TokenType> tokens) {
        Optional<String> styleId = DocumentMatcherParser.parseStyleId(tokens);
        Optional<StringMatcher> styleName = DocumentMatcherParser.parseStyleName(tokens);
        return new RunMatcher(styleId, styleName);
    }

    private static TableMatcher parseTableMatcher(TokenIterator<TokenType> tokens) {
        Optional<String> styleId = DocumentMatcherParser.parseStyleId(tokens);
        Optional<StringMatcher> styleName = DocumentMatcherParser.parseStyleName(tokens);
        return new TableMatcher(styleId, styleName);
    }

    private static Optional<String> parseStyleId(TokenIterator<TokenType> tokens) {
        return TokenParser.parseClassName(tokens);
    }

    private static Optional<StringMatcher> parseStyleName(TokenIterator<TokenType> tokens) {
        if (tokens.trySkip(TokenType.SYMBOL, "[")) {
            tokens.skip(TokenType.IDENTIFIER, "style-name");
            StringMatcher stringMatcher = DocumentMatcherParser.parseStringMatcher(tokens);
            tokens.skip(TokenType.SYMBOL, "]");
            return Optional.of(stringMatcher);
        }
        return Optional.empty();
    }

    private static StringMatcher parseStringMatcher(TokenIterator<TokenType> tokens) {
        if (tokens.trySkip(TokenType.SYMBOL, "=")) {
            return new EqualToStringMatcher(TokenParser.parseString(tokens));
        }
        if (tokens.trySkip(TokenType.SYMBOL, "^=")) {
            return new StartsWithStringMatcher(TokenParser.parseString(tokens));
        }
        throw LineParseException.lineParseException(tokens.next(), "Expected string matcher but got token " + tokens.next().getValue());
    }

    private static Optional<NumberingLevel> parseNumbering(TokenIterator<TokenType> tokens) {
        if (tokens.trySkip(TokenType.SYMBOL, ":")) {
            boolean isOrdered = DocumentMatcherParser.parseListType(tokens);
            tokens.skip(TokenType.SYMBOL, "(");
            String level = new BigInteger(tokens.nextValue(TokenType.INTEGER)).subtract(BigInteger.ONE).toString();
            tokens.skip(TokenType.SYMBOL, ")");
            return Optional.of(new NumberingLevel(level, isOrdered));
        }
        return Optional.empty();
    }

    private static boolean parseListType(TokenIterator<TokenType> tokens) {
        Token<TokenType> listType = tokens.next(TokenType.IDENTIFIER);
        switch (listType.getValue()) {
            case "ordered-list": {
                return true;
            }
            case "unordered-list": {
                return false;
            }
        }
        throw LineParseException.lineParseException(listType, "Unrecognised list type: " + listType);
    }

    private static HighlightMatcher parseHighlightMatcher(TokenIterator<TokenType> tokens) {
        Optional<String> color = Optional.empty();
        if (tokens.trySkip(TokenType.SYMBOL, "[")) {
            tokens.skip(TokenType.IDENTIFIER, "color");
            tokens.skip(TokenType.SYMBOL, "=");
            color = Optional.of(TokenParser.parseString(tokens));
            tokens.skip(TokenType.SYMBOL, "]");
        } else {
            color = Optional.empty();
        }
        return new HighlightMatcher(color);
    }

    private static BreakMatcher parseBreakMatcher(TokenIterator<TokenType> tokens) {
        String typeName;
        tokens.skip(TokenType.SYMBOL, "[");
        tokens.skip(TokenType.IDENTIFIER, "type");
        tokens.skip(TokenType.SYMBOL, "=");
        Token<TokenType> stringToken = tokens.next(TokenType.STRING);
        tokens.skip(TokenType.SYMBOL, "]");
        switch (typeName = TokenParser.parseStringToken(stringToken)) {
            case "line": {
                return BreakMatcher.LINE_BREAK;
            }
            case "page": {
                return BreakMatcher.PAGE_BREAK;
            }
            case "column": {
                return BreakMatcher.COLUMN_BREAK;
            }
        }
        throw LineParseException.lineParseException(stringToken, "Unrecognised break type: " + typeName);
    }
}

