/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.Optional;
import org.zwobble.mammoth.internal.documents.Run;
import org.zwobble.mammoth.internal.styles.DocumentElementMatcher;
import org.zwobble.mammoth.internal.styles.DocumentElementMatching;
import org.zwobble.mammoth.internal.styles.EqualToStringMatcher;
import org.zwobble.mammoth.internal.styles.StringMatcher;

public class RunMatcher
implements DocumentElementMatcher<Run> {
    public static final RunMatcher ANY = new RunMatcher(Optional.empty(), Optional.empty());
    private final Optional<String> styleId;
    private final Optional<StringMatcher> styleName;

    public static RunMatcher styleId(String styleId) {
        return new RunMatcher(Optional.of(styleId), Optional.empty());
    }

    public static RunMatcher styleName(String styleName) {
        return new RunMatcher(Optional.empty(), Optional.of(new EqualToStringMatcher(styleName)));
    }

    public RunMatcher(Optional<String> styleId, Optional<StringMatcher> styleName) {
        this.styleId = styleId;
        this.styleName = styleName;
    }

    @Override
    public boolean matches(Run run) {
        return DocumentElementMatching.matchesStyle(this.styleId, this.styleName, run.getStyle());
    }
}

