/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.styles;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.styles.HtmlPathElement;
import org.zwobble.mammoth.internal.styles.HtmlPathElements;
import org.zwobble.mammoth.internal.styles.Ignore;
import org.zwobble.mammoth.internal.util.Lists;
import org.zwobble.mammoth.internal.util.Maps;

public interface HtmlPath {
    public static final HtmlPath EMPTY = new HtmlPathElements(Lists.list());
    public static final HtmlPath IGNORE = Ignore.INSTANCE;

    public static HtmlPath elements(HtmlPathElement ... elements) {
        return new HtmlPathElements(Arrays.asList(elements));
    }

    public static HtmlPath element(String tagName) {
        return HtmlPath.element(tagName, Maps.map());
    }

    public static HtmlPath element(String tagName, Map<String, String> attributes) {
        HtmlTag tag = new HtmlTag(Lists.list(tagName), attributes, false, "");
        return new HtmlPathElements(Lists.list(new HtmlPathElement(tag)));
    }

    public static HtmlPath collapsibleElement(String tagName) {
        return HtmlPath.collapsibleElement(tagName, Maps.map());
    }

    public static HtmlPath collapsibleElement(List<String> tagNames) {
        return HtmlPath.collapsibleElement(tagNames, Maps.map());
    }

    public static HtmlPath collapsibleElement(String tagName, Map<String, String> attributes) {
        return HtmlPath.collapsibleElement(Lists.list(tagName), attributes);
    }

    public static HtmlPath collapsibleElement(List<String> tagNames, Map<String, String> attributes) {
        HtmlTag tag = new HtmlTag(tagNames, attributes, true, "");
        return new HtmlPathElements(Lists.list(new HtmlPathElement(tag)));
    }

    public Supplier<List<HtmlNode>> wrap(Supplier<List<HtmlNode>> var1);
}

