/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.html;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zwobble.mammoth.internal.html.HtmlNode;
import org.zwobble.mammoth.internal.html.HtmlTag;
import org.zwobble.mammoth.internal.util.Sets;

public class HtmlElement
implements HtmlNode {
    private final HtmlTag tag;
    private final List<HtmlNode> children;
    private static final Set<String> VOID_TAG_NAMES = Sets.set("br", "hr", "img", "input");

    public HtmlElement(HtmlTag tag, List<HtmlNode> children) {
        this.tag = tag;
        this.children = children;
    }

    public HtmlTag getTag() {
        return this.tag;
    }

    public List<String> getTagNames() {
        return this.tag.getTagNames();
    }

    public String getTagName() {
        return this.getTagNames().get(0);
    }

    public Map<String, String> getAttributes() {
        return this.tag.getAttributes();
    }

    public List<HtmlNode> getChildren() {
        return this.children;
    }

    public boolean isCollapsible() {
        return this.tag.isCollapsible();
    }

    public String getSeparator() {
        return this.tag.getSeparator();
    }

    public boolean isVoid() {
        return this.children.isEmpty() && HtmlElement.isVoidTag(this.getTagName());
    }

    private static boolean isVoidTag(String tagName) {
        return VOID_TAG_NAMES.contains(tagName);
    }

    @Override
    public void accept(HtmlNode.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(HtmlNode.Mapper<T> visitor) {
        return visitor.visit(this);
    }
}

