/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.docx;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Optional;
import org.zwobble.mammoth.internal.docx.FileReader;

public class PathRelativeFileReader
implements FileReader {
    private final Optional<Path> path;

    public PathRelativeFileReader(Optional<Path> path) {
        this.path = path;
    }

    @Override
    public InputStream getInputStream(String uri) throws IOException {
        try {
            Optional<URI> absoluteUri = PathRelativeFileReader.asAbsoluteUri(uri);
            if (absoluteUri.isPresent()) {
                return PathRelativeFileReader.open(absoluteUri.get());
            }
            if (this.path.isPresent()) {
                return PathRelativeFileReader.open(this.path.get().toUri().resolve(uri));
            }
            throw new IOException("path of document is unknown, but is required for relative URI");
        }
        catch (IOException exception) {
            throw new IOException("could not open external image '" + uri + "': " + exception.getMessage());
        }
    }

    private static InputStream open(URI uri) throws IOException {
        return uri.toURL().openStream();
    }

    private static Optional<URI> asAbsoluteUri(String uriString) {
        try {
            URI uri = new URI(uriString);
            return uri.isAbsolute() ? Optional.of(uri) : Optional.empty();
        }
        catch (URISyntaxException exception) {
            return Optional.empty();
        }
    }
}

