/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.documents;

import java.util.List;
import java.util.Optional;
import org.zwobble.mammoth.internal.documents.DocumentElement;
import org.zwobble.mammoth.internal.documents.DocumentElementVisitor;
import org.zwobble.mammoth.internal.documents.HasChildren;
import org.zwobble.mammoth.internal.documents.NumberingLevel;
import org.zwobble.mammoth.internal.documents.ParagraphIndent;
import org.zwobble.mammoth.internal.documents.Style;

public class Paragraph
implements DocumentElement,
HasChildren<Paragraph> {
    private final Optional<Style> style;
    private final Optional<NumberingLevel> numbering;
    private final ParagraphIndent indent;
    private final List<DocumentElement> children;

    public Paragraph(Optional<Style> style, Optional<NumberingLevel> numbering, ParagraphIndent indent, List<DocumentElement> children) {
        this.style = style;
        this.numbering = numbering;
        this.indent = indent;
        this.children = children;
    }

    public Optional<Style> getStyle() {
        return this.style;
    }

    public Optional<NumberingLevel> getNumbering() {
        return this.numbering;
    }

    public ParagraphIndent getIndent() {
        return this.indent;
    }

    @Override
    public List<DocumentElement> getChildren() {
        return this.children;
    }

    @Override
    public Paragraph replaceChildren(List<DocumentElement> newChildren) {
        return new Paragraph(this.style, this.numbering, this.indent, newChildren);
    }

    @Override
    public <T, U> T accept(DocumentElementVisitor<T, U> visitor, U context) {
        return visitor.visit(this, context);
    }
}

