/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.archives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zwobble.mammoth.internal.util.Lists;

public class ZipPaths {
    private ZipPaths() {
    }

    public static SplitPath splitPath(String path) {
        int index = path.lastIndexOf("/");
        if (index == -1) {
            return new SplitPath("", path);
        }
        String dirname = path.substring(0, index);
        String basename = path.substring(index + 1);
        return new SplitPath(dirname, basename);
    }

    public static String joinPath(String ... paths) {
        List<String> nonEmptyPaths = Lists.eagerFilter(Arrays.asList(paths), path -> !path.isEmpty());
        ArrayList<String> relevantPaths = new ArrayList<String>();
        for (String path2 : nonEmptyPaths) {
            if (path2.startsWith("/")) {
                relevantPaths.clear();
            }
            relevantPaths.add(path2);
        }
        return String.join((CharSequence)"/", relevantPaths);
    }

    public static class SplitPath {
        private final String dirname;
        private final String basename;

        public SplitPath(String dirname, String basename) {
            this.dirname = dirname;
            this.basename = basename;
        }

        public String getDirname() {
            return this.dirname;
        }

        public String getBasename() {
            return this.basename;
        }
    }
}

