/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal.archives;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.zwobble.mammoth.internal.archives.MutableArchive;
import org.zwobble.mammoth.internal.util.Maps;
import org.zwobble.mammoth.internal.util.PassThroughException;
import org.zwobble.mammoth.internal.util.Streams;

public class InMemoryArchive
implements MutableArchive {
    private final Map<String, byte[]> entries;

    public static InMemoryArchive fromStream(InputStream stream) throws IOException {
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(stream);
        HashMap<String, byte[]> entries = new HashMap<String, byte[]>();
        while ((entry = zipStream.getNextEntry()) != null) {
            entries.put(entry.getName(), Streams.toByteArray(zipStream));
        }
        return new InMemoryArchive(entries);
    }

    public static InMemoryArchive fromStrings(Map<String, String> entries) {
        return new InMemoryArchive(Maps.eagerMapValues(entries, value -> value.getBytes(StandardCharsets.UTF_8)));
    }

    public InMemoryArchive(Map<String, byte[]> entries) {
        this.entries = entries;
    }

    @Override
    public Optional<InputStream> tryGetInputStream(String name) throws IOException {
        return Maps.lookup(this.entries, name).map(ByteArrayInputStream::new);
    }

    @Override
    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public void writeEntry(String path, String content) {
        this.entries.put(path, content.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] toByteArray() {
        return PassThroughException.wrap(() -> {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
                for (Map.Entry<String, byte[]> entry : this.entries.entrySet()) {
                    zipStream.putNextEntry(new ZipEntry(entry.getKey()));
                    zipStream.write(entry.getValue());
                }
            }
            return outputStream.toByteArray();
        });
    }
}

