/*
 * Decompiled with CFR 0.152.
 */
package org.zwobble.mammoth.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import org.zwobble.mammoth.internal.archives.Archive;
import org.zwobble.mammoth.internal.archives.InMemoryArchive;
import org.zwobble.mammoth.internal.archives.ZippedArchive;
import org.zwobble.mammoth.internal.conversion.DocumentToHtml;
import org.zwobble.mammoth.internal.conversion.DocumentToHtmlOptions;
import org.zwobble.mammoth.internal.conversion.RawText;
import org.zwobble.mammoth.internal.docx.DocumentReader;
import org.zwobble.mammoth.internal.docx.EmbeddedStyleMap;
import org.zwobble.mammoth.internal.html.Html;
import org.zwobble.mammoth.internal.results.InternalResult;
import org.zwobble.mammoth.internal.styles.StyleMap;
import org.zwobble.mammoth.internal.styles.parsing.StyleMapParser;
import org.zwobble.mammoth.internal.util.PassThroughException;

public class InternalDocumentConverter {
    private final DocumentToHtmlOptions options;

    public InternalDocumentConverter(DocumentToHtmlOptions options) {
        this.options = options;
    }

    public InternalResult<String> convertToHtml(InputStream stream) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(stream, (Archive zipFile) -> this.convertToHtml(Optional.empty(), (Archive)zipFile)));
    }

    public InternalResult<String> convertToHtml(File file) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(file, (Archive zipFile) -> this.convertToHtml(Optional.of(file.toPath()), (Archive)zipFile)));
    }

    private InternalResult<String> convertToHtml(Optional<Path> path, Archive zipFile) {
        Optional<StyleMap> styleMap = this.readEmbeddedStyleMap(zipFile).map(StyleMapParser::parse);
        DocumentToHtmlOptions conversionOptions = styleMap.map(this.options::addEmbeddedStyleMap).orElse(this.options);
        return DocumentReader.readDocument(path, zipFile).flatMap(nodes -> DocumentToHtml.convertToHtml(nodes, conversionOptions)).map(Html::stripEmpty).map(Html::collapse).map(Html::write);
    }

    private Optional<String> readEmbeddedStyleMap(Archive zipFile) {
        return PassThroughException.wrap(() -> EmbeddedStyleMap.readStyleMap(zipFile));
    }

    public InternalResult<String> extractRawText(InputStream stream) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(stream, (Archive zipFile) -> this.extractRawText(Optional.empty(), (Archive)zipFile)));
    }

    public InternalResult<String> extractRawText(File file) throws IOException {
        return PassThroughException.unwrap(() -> InternalDocumentConverter.withDocxFile(file, (Archive zipFile) -> this.extractRawText(Optional.of(file.toPath()), (Archive)zipFile)));
    }

    private InternalResult<String> extractRawText(Optional<Path> path, Archive zipFile) {
        return DocumentReader.readDocument(path, zipFile).map(RawText::extractRawText);
    }

    private static <T> T withDocxFile(File file, Function<Archive, T> function) throws IOException {
        try (ZippedArchive zipFile = new ZippedArchive(file);){
            T t = function.apply(zipFile);
            return t;
        }
    }

    private static <T> T withDocxFile(InputStream stream, Function<Archive, T> function) throws IOException {
        try (InMemoryArchive zipFile = InMemoryArchive.fromStream(stream);){
            T t = function.apply(zipFile);
            return t;
        }
    }
}

