/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow.runtime;

import java.security.NoSuchAlgorithmException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.wildfly.swarm.config.undertow.Server;
import org.wildfly.swarm.internal.SwarmMessages;
import org.wildfly.swarm.spi.api.Customizer;
import org.wildfly.swarm.spi.runtime.annotations.Post;
import org.wildfly.swarm.undertow.UndertowFraction;

@Post
@ApplicationScoped
public class HTTP2Customizer
implements Customizer {
    @Inject
    UndertowFraction undertow;
    public static final String REQUIRED_CIPHER = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";

    public void customize() {
        if (!this.supportsHTTP2()) {
            SwarmMessages.MESSAGES.http2NotSupported();
            return;
        }
        for (Server server : this.undertow.subresources().servers()) {
            server.subresources().httpsListeners().forEach(httpsListener -> httpsListener.enableHttp2(Boolean.valueOf(true)));
        }
    }

    protected boolean supportsHTTP2() {
        try {
            String[] ciphers;
            SSLContext context = SSLContext.getDefault();
            SSLEngine engine = context.createSSLEngine();
            for (String i : ciphers = engine.getEnabledCipherSuites()) {
                if (!i.equals(REQUIRED_CIPHER)) continue;
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }
}

