/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNRemoteStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.SVNStatusReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNStatusClient16
extends SVNBasicDelegate {
    private ISVNStatusFileProvider myFilesProvider;

    public SVNStatusClient16(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNStatusClient16(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.HEAD, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, false, handler, null);
    }

    public long doStatus(File path, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, SVNRevision.HEAD, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, collectParentExternals, handler, null);
    }

    public long doStatus(File path, SVNRevision revision, boolean recursive, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, ISVNStatusHandler handler) throws SVNException {
        return this.doStatus(path, revision, SVNDepth.fromRecurse(recursive), remote, reportAll, includeIgnored, collectParentExternals, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doStatus(File path, SVNRevision revision, SVNDepth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, final ISVNStatusHandler handler, final Collection changeLists) throws SVNException {
        SVNStatusEditor editor;
        block26: {
            if (handler == null) {
                return -1L;
            }
            depth = depth == null ? SVNDepth.UNKNOWN : depth;
            SVNWCAccess wcAccess = this.createWCAccess();
            editor = null;
            final boolean[] deletedInRepository = new boolean[]{false};
            ISVNStatusHandler realHandler = new ISVNStatusHandler(){

                @Override
                public void handleStatus(SVNStatus status) throws SVNException {
                    if (deletedInRepository[0] && status.getEntry() != null) {
                        status.setRemoteNodeStatus(SVNStatusType.STATUS_DELETED);
                    }
                    if (!SVNWCAccess.matchesChangeList(changeLists, status.getEntry())) {
                        return;
                    }
                    handler.handleStatus(status);
                }
            };
            try {
                SVNAdminAreaInfo info = null;
                try {
                    SVNAdminArea anchor = wcAccess.open(path, false, SVNDepth.recurseFromDepth(depth) ? -1 : 1);
                    info = new SVNAdminAreaInfo(wcAccess, anchor, anchor, "");
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                        info = wcAccess.openAnchor(path, false, SVNDepth.recurseFromDepth(depth) ? -1 : 1);
                        if (depth == SVNDepth.EMPTY) {
                            depth = SVNDepth.IMMEDIATES;
                        }
                    }
                    throw svne;
                }
                SVNEntry entry = null;
                if (remote) {
                    SVNAdminArea anchor = info.getAnchor();
                    entry = wcAccess.getVersionedEntry(anchor.getRoot(), false);
                    if (entry.getURL() == null) {
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)info.getAnchor().getRoot());
                        SVNErrorManager.error(error, SVNLogType.WC);
                    }
                    SVNURL url = entry.getSVNURL();
                    SVNRepository repository = this.createRepository(url, anchor.getRoot(), wcAccess, true);
                    long rev = revision == SVNRevision.HEAD ? -1L : this.getRevisionNumber(revision, repository, path);
                    SVNNodeKind kind = repository.checkPath("", rev);
                    this.checkCancelled();
                    SVNReporter reporter = null;
                    if (kind == SVNNodeKind.NONE) {
                        if (!entry.isScheduledForAddition()) {
                            deletedInRepository[0] = true;
                        }
                        editor = new SVNStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, depth, realHandler);
                        this.checkCancelled();
                        editor.closeEdit();
                    } else {
                        editor = new SVNRemoteStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, depth, realHandler);
                        SVNRepository locksRepos = this.createRepository(url, anchor.getRoot(), wcAccess, false);
                        this.checkCancelled();
                        boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
                        reporter = new SVNReporter(info, path, false, !serverSupportsDepth, depth, false, true, true, this.getDebugLog());
                        SVNStatusReporter statusReporter = new SVNStatusReporter(locksRepos, reporter, editor);
                        String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
                        repository.status(rev, target, depth, (ISVNReporterBaton)statusReporter, SVNCancellableEditor.newInstance((ISVNEditor)((Object)editor), this.getEventDispatcher(), this.getDebugLog()));
                    }
                    if (this.getEventDispatcher() != null) {
                        long reportedFiles = reporter != null ? reporter.getReportedFilesCount() : 0L;
                        long totalFiles = reporter != null ? reporter.getTotalFilesCount() : 0L;
                        SVNEvent event = SVNEventFactory.createSVNEvent(info.getAnchor().getFile(info.getTargetName()), SVNNodeKind.NONE, null, editor.getTargetRevision(), SVNEventAction.STATUS_COMPLETED, null, null, null, reportedFiles, totalFiles);
                        this.getEventDispatcher().handleEvent(event, -1.0);
                    }
                } else {
                    editor = new SVNStatusEditor(this.getOptions(), wcAccess, info, includeIgnored, reportAll, depth, handler);
                    if (this.myFilesProvider != null) {
                        editor.setFileProvider(this.myFilesProvider);
                    }
                    editor.closeEdit();
                }
                if (this.isIgnoreExternals() || depth != SVNDepth.INFINITY && depth != SVNDepth.UNKNOWN) break block26;
                Map externalsMap = info.getNewExternals();
                for (String ownerPath : externalsMap.keySet()) {
                    String externalValue = (String)externalsMap.get(ownerPath);
                    SVNExternal[] externals = SVNExternal.parseExternals(ownerPath, externalValue);
                    for (int i = 0; i < externals.length; ++i) {
                        SVNExternal external = externals[i];
                        String externalPath = SVNPathUtil.append(ownerPath, external.getPath());
                        File externalFile = info.getAnchor().getFile(externalPath);
                        if (SVNFileType.getType(externalFile) != SVNFileType.DIRECTORY) continue;
                        try {
                            int format = SVNAdminAreaFactory.checkWC(externalFile, true);
                            if (format == 0) {
                            }
                        }
                        catch (SVNException e) {}
                        continue;
                        this.handleEvent(SVNEventFactory.createSVNEvent(externalFile, SVNNodeKind.DIR, null, -1L, SVNEventAction.STATUS_EXTERNAL, null, null, null), -1.0);
                        this.setEventPathPrefix(externalPath);
                        try {
                            this.doStatus(externalFile, SVNRevision.HEAD, depth, remote, reportAll, includeIgnored, false, handler, null);
                            continue;
                        }
                        catch (SVNException e) {
                            if (!(e instanceof SVNCancelException)) continue;
                            throw e;
                        }
                        finally {
                            this.setEventPathPrefix(null);
                        }
                    }
                }
            }
            finally {
                wcAccess.close();
            }
        }
        return editor.getTargetRevision();
    }

    public SVNStatus doStatus(File path, boolean remote) throws SVNException {
        return this.doStatus(path, remote, false);
    }

    public SVNStatus doStatus(File path, boolean remote, boolean collectParentExternals) throws SVNException {
        final SVNStatus[] result = new SVNStatus[]{null};
        final File absPath = path.getAbsoluteFile();
        ISVNStatusHandler handler = new ISVNStatusHandler(){

            @Override
            public void handleStatus(SVNStatus status) {
                if (absPath.equals(status.getFile())) {
                    if (result[0] != null && result[0].getContentsStatus() == SVNStatusType.STATUS_EXTERNAL && absPath.isDirectory()) {
                        result[0] = status;
                        result[0].markExternal();
                    } else if (result[0] == null) {
                        result[0] = status;
                    }
                }
            }
        };
        this.doStatus(absPath, SVNRevision.HEAD, SVNDepth.EMPTY, remote, true, true, collectParentExternals, handler, null);
        return result[0];
    }

    public void setFilesProvider(ISVNStatusFileProvider filesProvider) {
        this.myFilesProvider = filesProvider;
    }
}

