/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetTableStatement;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public abstract class SVNSqlJetInsertStatement
extends SVNSqlJetTableStatement {
    protected SqlJetConflictAction conflictAction = null;

    public SVNSqlJetInsertStatement(SVNSqlJetDb sDb, Enum<?> tableName) throws SVNException {
        super(sDb, tableName);
        this.transactionMode = SqlJetTransactionMode.WRITE;
        if (SVNWCDbSchema.NODES == tableName) {
            SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
            this.addTrigger(trigger);
        }
    }

    public SVNSqlJetInsertStatement(SVNSqlJetDb sDb, Enum<?> tableName, SqlJetConflictAction conflictAction) throws SVNException {
        this(sDb, tableName);
        this.conflictAction = conflictAction;
    }

    @Override
    public long exec() throws SVNException {
        Map<String, Object> insertValues = this.getInsertValues();
        if (insertValues == null) {
            return 0L;
        }
        this.statementStarted();
        try {
            this.beforeInsert(this.conflictAction, this.table, insertValues);
            long n = this.table.insertByFieldNamesOr(this.conflictAction, insertValues);
            this.statementCompleted(null);
            return n;
        }
        catch (SqlJetException e) {
            this.statementCompleted(e);
            SVNSqlJetDb.createSqlJetError(e);
            return -1L;
        }
    }

    private void beforeInsert(SqlJetConflictAction conflictAction, ISqlJetTable table, Map<String, Object> insertValues) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.beforeInsert(conflictAction, table, insertValues);
            }
            catch (SqlJetException e) {}
        }
    }

    protected abstract Map<String, Object> getInsertValues() throws SVNException;
}

