/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.replicator;

import java.util.Iterator;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.replicator.ISVNReplicationHandler;
import org.tmatesoft.svn.core.replicator.SVNReplicationEditor;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNRepositoryReplicator
implements ISVNEventHandler {
    private ISVNReplicationHandler myHandler;

    private SVNRepositoryReplicator() {
    }

    public static SVNRepositoryReplicator newInstance() {
        return new SVNRepositoryReplicator();
    }

    public long replicateRepository(SVNRepository src, SVNRepository dst, boolean incremental) throws SVNException {
        long fromRevision = incremental ? dst.getLatestRevision() + 1L : 1L;
        return this.replicateRepository(src, dst, fromRevision, -1L);
    }

    public long replicateRepository(SVNRepository src, SVNRepository dst, long fromRevision, long toRevision) throws SVNException {
        SVNErrorMessage err;
        fromRevision = fromRevision <= 0L ? 1L : fromRevision;
        long dstLatestRevision = dst.getLatestRevision();
        if (dstLatestRevision != fromRevision - 1L) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "The target repository''s latest revision must be ''{0}''", new Long(fromRevision - 1L));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!src.getRepositoryRoot(true).equals(src.getLocation())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Source repository location must be at repository root ({0}), not at {1}", new Object[]{src.getRepositoryRoot(true), src.getLocation()});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!dst.getRepositoryRoot(true).equals(dst.getLocation())) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Target repository location must be at repository root ({0}), not at {1}", new Object[]{dst.getRepositoryRoot(true), dst.getLocation()});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        long latestRev = src.getLatestRevision();
        toRevision = toRevision > 0L && toRevision <= latestRev ? toRevision : latestRev;
        final SVNLogEntry[] currentRevision = new SVNLogEntry[1];
        long count = toRevision - fromRevision + 1L;
        if (dstLatestRevision == 0L) {
            SVNProperties zeroRevisionProperties = src.getRevisionProperties(0L, null);
            this.updateRevisionProperties(dst, 0L, zeroRevisionProperties);
        }
        for (long i = fromRevision; i <= toRevision; ++i) {
            SVNErrorMessage err2;
            SVNProperties revisionProps = src.getRevisionProperties(i, null);
            String commitMessage = revisionProps.getStringValue("svn:log");
            currentRevision[0] = null;
            this.checkCancelled();
            src.log(new String[]{""}, i, i, true, false, 1L, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    currentRevision[0] = logEntry;
                }
            });
            this.checkCancelled();
            if (currentRevision[0] == null || currentRevision[0].getChangedPaths() == null) {
                err2 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Revision ''{0}'' does not contain information on changed paths; probably access is denied", new Long(i));
                SVNErrorManager.error(err2, SVNLogType.FSFS);
            } else if (currentRevision[0].getDate() == null) {
                err2 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Revision ''{0}'' does not contain commit date; probably access is denied", new Long(i));
                SVNErrorManager.error(err2, SVNLogType.FSFS);
            }
            this.fireReplicatingEvent(currentRevision[0]);
            commitMessage = commitMessage == null ? "" : commitMessage;
            ISVNEditor commitEditor = SVNCancellableEditor.newInstance(dst.getCommitEditor(commitMessage, null), this, src.getDebugLog());
            SVNReplicationEditor bridgeEditor = null;
            try {
                bridgeEditor = new SVNReplicationEditor(src, commitEditor, currentRevision[0]);
                final long previousRev = i - 1L;
                src.update(i, null, true, new ISVNReporterBaton(){

                    public void report(ISVNReporter reporter) throws SVNException {
                        reporter.setPath("", null, previousRev, SVNDepth.INFINITY, false);
                        reporter.finishReport();
                    }
                }, SVNCancellableEditor.newInstance(bridgeEditor, this, src.getDebugLog()));
            }
            catch (SVNException svne) {
                try {
                    bridgeEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                throw svne;
            }
            catch (Throwable th) {
                try {
                    bridgeEditor.abortEdit();
                }
                catch (SVNException e) {
                    // empty catch block
                }
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, th.getMessage());
                SVNErrorManager.error(err3, th, SVNLogType.FSFS);
            }
            SVNCommitInfo commitInfo = bridgeEditor.getCommitInfo();
            try {
                this.updateRevisionProperties(dst, i, revisionProps);
                String author = revisionProps.getStringValue("svn:author");
                SVNDate date = SVNDate.parseDate(revisionProps.getStringValue("svn:date"));
                commitInfo = new SVNCommitInfo(i, author, date);
            }
            catch (SVNException e) {
                // empty catch block
            }
            this.fireReplicatedEvent(commitInfo);
        }
        return count;
    }

    private void updateRevisionProperties(SVNRepository repository, long revision, SVNProperties properties) throws SVNException {
        if (!properties.containsName("svn:author")) {
            properties.put("svn:author", (byte[])null);
        }
        if (!properties.containsName("svn:date")) {
            properties.put("svn:date", (byte[])null);
        }
        if (!properties.containsName("svn:log")) {
            properties.put("svn:log", (byte[])null);
        }
        Iterator names = properties.nameSet().iterator();
        while (names.hasNext()) {
            this.checkCancelled();
            String name = (String)names.next();
            SVNPropertyValue value = properties.getSVNPropertyValue(name);
            repository.setRevisionPropertyValue(revision, name, value);
        }
    }

    public void setReplicationHandler(ISVNReplicationHandler handler) {
        this.myHandler = handler;
    }

    protected void fireReplicatingEvent(SVNLogEntry revision) throws SVNException {
        if (this.myHandler != null) {
            this.myHandler.revisionReplicating(this, revision);
        }
    }

    protected void fireReplicatedEvent(SVNCommitInfo commitInfo) throws SVNException {
        if (this.myHandler != null) {
            this.myHandler.revisionReplicated(this, commitInfo);
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
        if (this.myHandler != null) {
            this.myHandler.checkCancelled();
        }
    }
}

