/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.LazyEscapingCharSequence;
import org.unbescape.html.HtmlEscape;
import org.unbescape.xml.XmlEscape;

public final class StandardTextTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int PRECEDENCE = 1300;
    public static final String ATTR_NAME = "text";

    public StandardTextTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, ATTR_NAME, 1300, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        CharSequence text;
        TemplateMode templateMode = this.getTemplateMode();
        if (templateMode != TemplateMode.JAVASCRIPT && templateMode != TemplateMode.CSS) {
            String input;
            String string = input = expressionResult == null ? "" : expressionResult.toString();
            text = templateMode == TemplateMode.RAW ? input : (input.length() > 100 ? new LazyEscapingCharSequence(context.getConfiguration(), templateMode, input) : StandardTextTagProcessor.produceEscapedOutput(templateMode, input));
        } else {
            text = new LazyEscapingCharSequence(context.getConfiguration(), templateMode, expressionResult);
        }
        structureHandler.setBody(text, false);
    }

    private static String produceEscapedOutput(TemplateMode templateMode, String input) {
        switch (templateMode) {
            case TEXT: 
            case HTML: {
                return HtmlEscape.escapeHtml4Xml((String)input);
            }
            case XML: {
                return XmlEscape.escapeXml10((String)input);
            }
        }
        throw new TemplateProcessingException("Unrecognized template mode " + (Object)((Object)templateMode) + ". Cannot produce escaped output for this template mode.");
    }
}

