/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.EngineContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.IEngineContextFactory;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.WebEngineContext;
import org.thymeleaf.engine.TemplateData;
import org.thymeleaf.util.Validate;

public final class StandardEngineContextFactory
implements IEngineContextFactory {
    @Override
    public IEngineContext createEngineContext(IEngineConfiguration configuration, TemplateData templateData, Map<String, Object> templateResolutionAttributes, IContext context) {
        Validate.notNull(context, "Context object cannot be null");
        Set<String> variableNames = context.getVariableNames();
        if (variableNames == null || variableNames.isEmpty()) {
            if (context instanceof IWebContext) {
                IWebContext webContext = (IWebContext)context;
                return new WebEngineContext(configuration, templateData, templateResolutionAttributes, webContext.getRequest(), webContext.getResponse(), webContext.getServletContext(), webContext.getLocale(), Collections.EMPTY_MAP);
            }
            return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), Collections.EMPTY_MAP);
        }
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>(variableNames.size() + 1, 1.0f);
        for (String variableName : variableNames) {
            variables.put(variableName, context.getVariable(variableName));
        }
        if (context instanceof IWebContext) {
            IWebContext webContext = (IWebContext)context;
            return new WebEngineContext(configuration, templateData, templateResolutionAttributes, webContext.getRequest(), webContext.getResponse(), webContext.getServletContext(), webContext.getLocale(), variables);
        }
        return new EngineContext(configuration, templateData, templateResolutionAttributes, context.getLocale(), variables);
    }
}

