/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.thymeleaf.dom.CDATASection;
import org.thymeleaf.dom.DocType;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.templateparser.TemplatePreprocessingReader;
import org.thymeleaf.util.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardDOMTranslator {
    private StandardDOMTranslator() {
    }

    public static Node translateNode(org.w3c.dom.Node domNode, NestableNode parentNode, String documentName) {
        if (domNode instanceof Element) {
            return StandardDOMTranslator.translateElement((Element)domNode, parentNode, documentName);
        }
        if (domNode instanceof Comment) {
            return StandardDOMTranslator.translateComment((Comment)domNode, parentNode, documentName);
        }
        if (domNode instanceof org.w3c.dom.CDATASection) {
            return StandardDOMTranslator.translateCDATASection((org.w3c.dom.CDATASection)domNode, parentNode, documentName);
        }
        if (domNode instanceof Text) {
            return StandardDOMTranslator.translateText((Text)domNode, parentNode, documentName);
        }
        if (domNode instanceof org.w3c.dom.Document) {
            return StandardDOMTranslator.translateDocument((org.w3c.dom.Document)domNode, documentName);
        }
        throw new IllegalArgumentException("Node " + domNode.getNodeName() + " of type " + domNode.getNodeType() + " and class " + domNode.getClass().getName() + " cannot be converted to " + "Thymeleaf's DOM representation.");
    }

    public static Document translateDocument(org.w3c.dom.Document domDocument, String documentName) {
        return StandardDOMTranslator.translateDocument(domDocument, documentName, null);
    }

    public static Document translateDocument(org.w3c.dom.Document domDocument, String documentName, String originalDocTypeClause) {
        boolean xmlStandalone;
        String xmlEncoding;
        DocumentType domDocumentType = domDocument.getDoctype();
        NodeList children = domDocument.getChildNodes();
        Document document = new Document(documentName, StandardDOMTranslator.translateDocumentType(domDocumentType, originalDocTypeClause));
        String xmlVersion = domDocument.getXmlVersion();
        if (xmlVersion != null) {
            document.setNodeProperty("XML_VERSION", xmlVersion);
        }
        if ((xmlEncoding = domDocument.getXmlEncoding()) != null) {
            document.setNodeProperty("XML_ENCODING", xmlEncoding);
        }
        if (xmlStandalone = domDocument.getXmlStandalone()) {
            document.setNodeProperty("XML_STANDALONE", Boolean.TRUE);
        }
        int childrenLen = children.getLength();
        for (int i = 0; i < childrenLen; ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child instanceof DocumentType) continue;
            if (child instanceof Element) {
                List<Node> childNodes = StandardDOMTranslator.translateRootElement((Element)child, document, documentName);
                for (Node childNode : childNodes) {
                    document.addChild(childNode);
                }
                continue;
            }
            document.addChild(StandardDOMTranslator.translateNode(child, document, documentName));
        }
        return document;
    }

    public static DocType translateDocumentType(DocumentType domDocumentType) {
        return StandardDOMTranslator.translateDocumentType(domDocumentType, null);
    }

    public static DocType translateDocumentType(DocumentType domDocumentType, String originalDocTypeClause) {
        if (domDocumentType == null) {
            return null;
        }
        String rootElementName = domDocumentType.getName();
        return new DocType(rootElementName, domDocumentType.getPublicId(), domDocumentType.getSystemId(), originalDocTypeClause);
    }

    public static org.thymeleaf.dom.Element translateElement(Element domNode, NestableNode parentNode, String documentName) {
        String elementTagName = domNode.getTagName();
        org.thymeleaf.dom.Element element = new org.thymeleaf.dom.Element(elementTagName, documentName);
        element.setParent(parentNode);
        NamedNodeMap attributes = domNode.getAttributes();
        int attributesLen = attributes.getLength();
        for (int i = 0; i < attributesLen; ++i) {
            Attr attr = (Attr)attributes.item(i);
            element.setAttribute(attr.getName(), DOMUtils.unescapeXml(TemplatePreprocessingReader.removeEntitySubstitutions(attr.getValue()), true));
        }
        NodeList children = domNode.getChildNodes();
        int childrenLen = children.getLength();
        for (int i = 0; i < childrenLen; ++i) {
            org.w3c.dom.Node child = children.item(i);
            element.addChild(StandardDOMTranslator.translateNode(child, element, documentName));
        }
        return element;
    }

    private static List<Node> translateRootElement(Element domNode, NestableNode parentNode, String documentName) {
        String elementTagName = domNode.getTagName();
        if (!"THYMELEAF_ROOT".equals(elementTagName)) {
            return Collections.singletonList(StandardDOMTranslator.translateElement(domNode, parentNode, documentName));
        }
        NodeList children = domNode.getChildNodes();
        int childrenLen = children.getLength();
        ArrayList<Node> result = new ArrayList<Node>(childrenLen + 2);
        for (int i = 0; i < childrenLen; ++i) {
            org.w3c.dom.Node child = children.item(i);
            result.add(StandardDOMTranslator.translateNode(child, parentNode, documentName));
        }
        return result;
    }

    public static org.thymeleaf.dom.Comment translateComment(Comment domNode, NestableNode parentNode, String documentName) {
        org.thymeleaf.dom.Comment comment = new org.thymeleaf.dom.Comment(domNode.getData(), documentName);
        comment.setParent(parentNode);
        return comment;
    }

    public static CDATASection translateCDATASection(org.w3c.dom.CDATASection domNode, NestableNode parentNode, String documentName) {
        CDATASection cdata = new CDATASection(TemplatePreprocessingReader.removeEntitySubstitutions(domNode.getData()), false, documentName);
        cdata.setParent(parentNode);
        return cdata;
    }

    public static org.thymeleaf.dom.Text translateText(Text domNode, NestableNode parentNode, String documentName) {
        org.thymeleaf.dom.Text text = new org.thymeleaf.dom.Text(TemplatePreprocessingReader.removeEntitySubstitutions(domNode.getData()), false, documentName);
        text.setParent(parentNode);
        return text;
    }
}

