/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.internal.AnnotationTypeEnum;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTest
implements Serializable,
Cloneable {
    private final XmlSuite m_suite;
    private String m_name = "Command line suite";
    private Integer m_verbose;
    private Boolean m_isJUnit;
    private int m_threadCount = -1;
    private List<XmlClass> m_xmlClasses = new ArrayList<XmlClass>();
    private List<String> m_includedGroups = new ArrayList<String>();
    private List<String> m_excludedGroups = new ArrayList<String>();
    private final Map<String, List<String>> m_metaGroups = new HashMap<String, List<String>>();
    private Map<String, String> m_parameters = new HashMap<String, String>();
    private String m_parallel;
    private AnnotationTypeEnum m_annotations;
    private String m_expression;
    private List<XmlMethodSelector> m_methodSelectors = new ArrayList<XmlMethodSelector>();
    private List<XmlPackage> m_xmlPackages = new ArrayList<XmlPackage>();
    private String m_timeOut;
    private Boolean m_skipFailedInvocationCounts;

    public XmlTest(XmlSuite suite) {
        this.m_suite = suite;
        this.m_suite.getTests().add(this);
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = packages;
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = methodSelectors;
    }

    public XmlSuite getSuite() {
        return this.m_suite;
    }

    public List<String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setClassNames(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public List<XmlClass> getXmlClasses() {
        return this.m_xmlClasses;
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_xmlClasses = classes;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setVerbose(int v) {
        this.m_verbose = new Integer(v);
    }

    public int getThreadCount() {
        return this.m_threadCount > 0 ? this.m_threadCount : this.getSuite().getThreadCount();
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public void setIncludedGroups(List<String> g) {
        this.m_includedGroups = g;
    }

    public void setExcludedGroups(List<String> g) {
        this.m_excludedGroups = g;
    }

    public List<String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public int getVerbose() {
        Integer result = this.m_verbose;
        if (null == result) {
            result = this.m_suite.getVerbose();
        }
        return result;
    }

    public boolean isJUnit() {
        Boolean result = this.m_isJUnit;
        if (null == result) {
            result = this.m_suite.isJUnit();
        }
        return result;
    }

    public void setJUnit(boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public boolean skipFailedInvocationCounts() {
        Boolean result = this.m_skipFailedInvocationCounts;
        if (null == result) {
            result = this.m_suite.skipFailedInvocationCounts();
        }
        return result;
    }

    public void addMetaGroup(String name, List<String> metaGroup) {
        this.m_metaGroups.put(name, metaGroup);
    }

    public Map<String, List<String>> getMetaGroups() {
        return this.m_metaGroups;
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.put(key, value);
    }

    public String getParameter(String name) {
        String result = this.m_parameters.get(name);
        if (null == result) {
            result = this.m_suite.getParameter(name);
        }
        return result;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> parameters = this.getSuite().getParameters();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            result.put(parameter.getKey(), parameter.getValue());
        }
        for (String key : this.m_parameters.keySet()) {
            result.put(key, this.m_parameters.get(key));
        }
        return result;
    }

    public void setParallel(String parallel) {
        this.m_parallel = parallel;
    }

    public String getParallel() {
        String result = null;
        result = null != this.m_parallel ? this.m_parallel : this.m_suite.getParallel();
        return result;
    }

    public String getTimeOut() {
        String result = null;
        result = null != this.m_timeOut ? this.m_timeOut : this.m_suite.getTimeOut();
        return result;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.getTimeOut() != null) {
            result = new Long(this.getTimeOut());
        }
        return result;
    }

    public String getAnnotations() {
        return null != this.m_annotations ? this.m_annotations.toString() : this.m_suite.getAnnotations();
    }

    public void setAnnotations(String annotations) {
        this.m_annotations = AnnotationTypeEnum.valueOf(annotations);
    }

    public void setBeanShellExpression(String expression) {
        this.m_expression = expression;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        p.setProperty("junit", this.m_isJUnit != null ? this.m_isJUnit.toString() : "false");
        if (null != this.m_parallel && !"".equals(this.m_parallel)) {
            p.setProperty("parallel", this.m_parallel);
        }
        if (null != this.m_verbose) {
            p.setProperty("verbose", this.m_verbose.toString());
        }
        if (null != this.m_annotations) {
            p.setProperty("annotations", this.m_annotations.toString());
        }
        xsb.push("test", p);
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector xmlMethodSelector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(xmlMethodSelector.toXml(indent + "    "));
            }
            xsb.pop("method-selectors");
        }
        if (!this.m_parameters.isEmpty()) {
            for (Map.Entry entry : this.m_parameters.entrySet()) {
                Properties paramProps = new Properties();
                paramProps.setProperty("name", (String)entry.getKey());
                paramProps.setProperty("value", (String)entry.getValue());
                xsb.addEmptyElement("parameter", paramProps);
            }
        }
        if (!(this.m_metaGroups.isEmpty() && this.m_includedGroups.isEmpty() && this.m_excludedGroups.isEmpty())) {
            xsb.push("groups");
            for (String string : this.m_metaGroups.keySet()) {
                Properties metaGroupProp = new Properties();
                metaGroupProp.setProperty("name", string);
                xsb.push("define", metaGroupProp);
                for (String groupName : this.m_metaGroups.get(string)) {
                    Properties includeProps = new Properties();
                    includeProps.setProperty("name", groupName);
                    xsb.addEmptyElement("include", includeProps);
                }
                xsb.pop("define");
            }
            if (!this.m_includedGroups.isEmpty() || !this.m_excludedGroups.isEmpty()) {
                xsb.push("run");
                for (String string : this.m_includedGroups) {
                    Properties includeProps = new Properties();
                    includeProps.setProperty("name", string);
                    xsb.addEmptyElement("include", includeProps);
                }
                for (String string : this.m_excludedGroups) {
                    Properties excludeProps = new Properties();
                    excludeProps.setProperty("name", string);
                    xsb.addEmptyElement("exclude", excludeProps);
                }
                xsb.pop("run");
            }
            xsb.pop("groups");
        }
        if (null != this.m_xmlPackages && !this.m_xmlPackages.isEmpty()) {
            xsb.push("packages");
            for (XmlPackage xmlPackage : this.m_xmlPackages) {
                xsb.getStringBuffer().append(xmlPackage.toXml("  "));
            }
            xsb.pop("packages");
        }
        if (null != this.getXmlClasses() && !this.getXmlClasses().isEmpty()) {
            xsb.push("classes");
            for (XmlClass xmlClass : this.getXmlClasses()) {
                xsb.getStringBuffer().append(xmlClass.toXml(indent + "    "));
            }
            xsb.pop("classes");
        }
        xsb.pop("test");
        return xsb.toXML();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Test: \"" + this.m_name + "\"").append(" verbose:" + this.m_verbose);
        result.append("[parameters:");
        for (String k : this.m_parameters.keySet()) {
            String v = this.m_parameters.get(k);
            result.append(k + "=>" + v);
        }
        result.append("]");
        result.append("[metagroups:");
        for (String g : this.m_metaGroups.keySet()) {
            List<String> mg = this.m_metaGroups.get(g);
            result.append(g).append("=");
            for (String n : mg) {
                result.append(n).append(",");
            }
        }
        result.append("] ");
        result.append("[included: ");
        for (String g : this.m_includedGroups) {
            result.append(g).append(" ");
        }
        result.append("]");
        result.append("[excluded: ");
        for (String g : this.m_excludedGroups) {
            result.append(g).append("");
        }
        result.append("] ");
        result.append(" classes:");
        for (XmlClass cl : this.m_xmlClasses) {
            result.append(cl).append(" ");
        }
        result.append("] ");
        return result.toString();
    }

    static void ppp(String s) {
        System.out.println("[XmlTest] " + s);
    }

    public Object clone() {
        XmlTest result = new XmlTest(this.getSuite());
        result.setName(this.getName());
        result.setAnnotations(this.getAnnotations());
        result.setIncludedGroups(this.getIncludedGroups());
        result.setExcludedGroups(this.getExcludedGroups());
        result.setJUnit(this.isJUnit());
        result.setParallel(this.getParallel());
        result.setVerbose(this.getVerbose());
        result.setParameters(this.getParameters());
        result.setXmlPackages(this.getXmlPackages());
        Map<String, List<String>> metagroups = this.getMetaGroups();
        for (Map.Entry<String, List<String>> group : metagroups.entrySet()) {
            result.addMetaGroup(group.getKey(), group.getValue());
        }
        return result;
    }
}

