/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class DockerModelRunnerContainer
extends SocatContainer {
    private static final String MODEL_RUNNER_ENDPOINT = "model-runner.docker.internal";
    private static final int PORT = 80;

    public DockerModelRunnerContainer(String image) {
        this(DockerImageName.parse(image));
    }

    public DockerModelRunnerContainer(DockerImageName image) {
        super(image);
        this.withTarget(80, MODEL_RUNNER_ENDPOINT);
        this.waitingFor(Wait.forHttp("/").forResponsePredicate(res -> res.contains("The service is running")));
    }

    public String getBaseEndpoint() {
        return "http://" + this.getHost() + ":" + this.getMappedPort(80);
    }

    public String getOpenAIEndpoint() {
        return this.getBaseEndpoint() + "/engines";
    }
}

