/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.images.RemoteDockerImage;
import org.testcontainers.shaded.org.awaitility.Awaitility;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DynamicPollInterval;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;

@Deprecated
public class RyukResourceReaper
extends ResourceReaper {
    private static final Logger log = LoggerFactory.getLogger(RyukResourceReaper.class);
    private static final RateLimiter RYUK_ACK_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(4, TimeUnit.SECONDS).withConstantThroughput().build();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private String containerId = null;

    @Override
    public void init() {
        if (!TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
            log.debug("Ryuk is enabled");
            this.maybeStart();
            log.info("Ryuk started - will monitor and terminate Testcontainers containers on JVM exit");
        } else {
            log.debug("Ryuk is enabled but will be started on demand");
        }
    }

    @Override
    public void registerLabelsFilterForCleanup(Map<String, String> labels) {
        this.maybeStart();
        super.registerLabelsFilterForCleanup(labels);
    }

    @Override
    public Map<String, String> getLabels() {
        this.maybeStart();
        return super.getLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void maybeStart() {
        InspectContainerResponse inspectedContainer;
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        DockerClient client = DockerClientFactory.lazyClient();
        RemoteDockerImage ryukImage = new RemoteDockerImage(DockerImageName.parse("testcontainers/ryuk:0.3.3"));
        ArrayList<Bind> binds = new ArrayList<Bind>();
        binds.add(new Bind(DockerClientFactory.instance().getRemoteDockerUnixSocketPath(), new Volume("/var/run/docker.sock")));
        ExposedPort ryukExposedPort = ExposedPort.tcp((int)8080);
        this.containerId = client.createContainerCmd((String)ryukImage.get()).withHostConfig(new HostConfig().withAutoRemove(Boolean.valueOf(true)).withPortBindings(new PortBinding[]{new PortBinding(Ports.Binding.empty(), ryukExposedPort)})).withExposedPorts(new ExposedPort[]{ryukExposedPort}).withName("testcontainers-ryuk-" + DockerClientFactory.SESSION_ID).withLabels(Collections.singletonMap(DockerClientFactory.TESTCONTAINERS_LABEL, "true")).withBinds(binds).withPrivileged(Boolean.valueOf(TestcontainersConfiguration.getInstance().isRyukPrivileged())).exec().getId();
        client.startContainerCmd(this.containerId).exec();
        final StringBuilder ryukLog = new StringBuilder();
        ResultCallback.Adapter logCallback = (ResultCallback.Adapter)client.logContainerCmd(this.containerId).withSince(Integer.valueOf(0)).withFollowStream(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withStdErr(Boolean.valueOf(true)).exec((ResultCallback)new ResultCallback.Adapter<Frame>(){

            public void onNext(Frame frame) {
                ryukLog.append(new String(frame.getPayload(), StandardCharsets.UTF_8));
            }
        });
        try {
            inspectedContainer = Awaitility.await().atMost(5L, TimeUnit.SECONDS).pollInterval(DynamicPollInterval.ofMillis(50L)).pollInSameThread().until(() -> client.inspectContainerCmd(this.containerId).exec(), inspectContainerResponse -> inspectContainerResponse.getNetworkSettings().getPorts().getBindings().values().stream().anyMatch(Objects::nonNull));
        }
        catch (Exception e) {
            log.warn("Ryuk container cannot be inspected and probably had a problem starting. Ryuk's logs:\n{}", (Object)ryukLog);
            throw new IllegalStateException("Ryuk failed to start", e);
        }
        ContainerState containerState = new ContainerState(){

            @Override
            public List<Integer> getExposedPorts() {
                return Stream.of(this.getContainerInfo().getConfig().getExposedPorts()).map(ExposedPort::getPort).collect(Collectors.toList());
            }

            @Override
            public InspectContainerResponse getContainerInfo() {
                return inspectedContainer;
            }
        };
        CountDownLatch ryukScheduledLatch = new CountDownLatch(1);
        String host = containerState.getHost();
        Integer ryukPort = containerState.getFirstMappedPort();
        Thread kiraThread = new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> {
            while (true) {
                RYUK_ACK_RATE_LIMITER.doWhenReady(() -> {
                    int index = 0;
                    try {
                        Socket clientSocket = new Socket();
                        Throwable throwable = null;
                        try {
                            try {
                                clientSocket.connect(new InetSocketAddress(host, (int)ryukPort), 5000);
                                ResourceReaper.FilterRegistry registry = new ResourceReaper.FilterRegistry(clientSocket.getInputStream(), clientSocket.getOutputStream());
                                List<List<Map.Entry<String, String>>> list = ResourceReaper.DEATH_NOTE;
                                synchronized (list) {
                                    while (true) {
                                        if (ResourceReaper.DEATH_NOTE.size() <= index) {
                                            try {
                                                ResourceReaper.DEATH_NOTE.wait(1000L);
                                            }
                                            catch (InterruptedException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        List<Map.Entry<String, String>> filters = ResourceReaper.DEATH_NOTE.get(index);
                                        boolean isAcknowledged = registry.register(filters);
                                        if (isAcknowledged) {
                                            log.debug("Received 'ACK' from Ryuk");
                                            ryukScheduledLatch.countDown();
                                            ++index;
                                            continue;
                                        }
                                        log.debug("Didn't receive 'ACK' from Ryuk. Will retry to send filters.");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (clientSocket != null) {
                                if (throwable != null) {
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    clientSocket.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        log.warn("Can not connect to Ryuk at {}:{}", new Object[]{host, ryukPort, e});
                        return;
                    }
                });
            }
        }, "testcontainers-ryuk");
        kiraThread.setDaemon(true);
        kiraThread.start();
        try {
            if (!ryukScheduledLatch.await(TestcontainersConfiguration.getInstance().getRyukTimeout().intValue(), TimeUnit.SECONDS)) {
                log.error("Timed out waiting for Ryuk container to start. Ryuk's logs:\n{}", (Object)ryukLog);
                throw new IllegalStateException(String.format("Could not connect to Ryuk at %s:%s", host, ryukPort));
            }
        }
        finally {
            try {
                logCallback.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getContainerId() {
        return this.containerId;
    }
}

