/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.rnorth.ducttape.timeouts.Timeouts;

public abstract class LazyFuture<T>
implements Future<T> {
    private final Future<T> delegate = CompletableFuture.completedFuture(null);
    private final AtomicReference<Object> resolvedValue = new AtomicReference();

    protected abstract T resolve();

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.getResolvedValue();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (T)Timeouts.getWithTimeout((int)((int)timeout), (TimeUnit)unit, this::get);
        }
        catch (org.rnorth.ducttape.TimeoutException e) {
            throw new TimeoutException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getResolvedValue() {
        Object value = this.resolvedValue.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.resolvedValue;
            synchronized (atomicReference) {
                value = this.resolvedValue.get();
                if (value == null) {
                    T actualValue = this.resolve();
                    value = actualValue == null ? this.resolvedValue : actualValue;
                    this.resolvedValue.set(value);
                }
            }
        }
        return (T)(value == this.resolvedValue ? null : value);
    }

    @Override
    public boolean cancel(boolean arg0) {
        return this.delegate.cancel(arg0);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    private static interface Excludes<T> {
        public T get();

        public T get(long var1, TimeUnit var3);
    }
}

