/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.core.DockerClientConfig;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.LogToStringContainerCallback;
import org.testcontainers.shaded.org.apache.commons.lang.StringUtils;

public class DockerClientConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(DockerClientConfigUtils.class);
    public static final boolean IN_A_CONTAINER = new File("/.dockerenv").exists();
    @Deprecated
    private static final AtomicReference<Object> detectedDockerHostIp = new AtomicReference();
    private static final AtomicReference<Object> defaultGateway = new AtomicReference();

    public static String getDockerHostIpAddress(DockerClientConfig config) {
        switch (config.getDockerHost().getScheme()) {
            case "http": 
            case "https": 
            case "tcp": {
                return config.getDockerHost().getHost();
            }
            case "unix": 
            case "npipe": {
                if (IN_A_CONTAINER) {
                    return DockerClientConfigUtils.getDefaultGateway().orElse("localhost");
                }
                return "localhost";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Optional<String> getDetectedDockerHostIp() {
        Object value = detectedDockerHostIp.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = detectedDockerHostIp;
            synchronized (atomicReference) {
                value = detectedDockerHostIp.get();
                if (value == null) {
                    Optional<String> actualValue = IN_A_CONTAINER ? DockerClientConfigUtils.getDefaultGateway() : Optional.empty();
                    value = actualValue == null ? detectedDockerHostIp : actualValue;
                    detectedDockerHostIp.set(value);
                }
            }
        }
        return (Optional)(value == detectedDockerHostIp ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<String> getDefaultGateway() {
        Object value = defaultGateway.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = defaultGateway;
            synchronized (atomicReference) {
                value = defaultGateway.get();
                if (value == null) {
                    Optional<String> actualValue = Optional.ofNullable(DockerClientFactory.instance().runInsideDocker(cmd -> cmd.withCmd("sh", "-c", "ip route|awk '/default/ { print $3 }'"), (client, id) -> {
                        try {
                            LogToStringContainerCallback loggingCallback = new LogToStringContainerCallback();
                            client.logContainerCmd((String)id).withStdOut(true).withFollowStream(true).exec(loggingCallback).awaitStarted();
                            loggingCallback.awaitCompletion(3L, TimeUnit.SECONDS);
                            return loggingCallback.toString();
                        }
                        catch (Exception e) {
                            log.warn("Can't parse the default gateway IP", (Throwable)e);
                            return null;
                        }
                    })).map(StringUtils::trimToEmpty).filter(StringUtils::isNotBlank);
                    value = actualValue == null ? defaultGateway : actualValue;
                    defaultGateway.set(value);
                }
            }
        }
        return (Optional)(value == defaultGateway ? null : value);
    }
}

