/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import java.io.File;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ComposeServiceWaitStrategyTarget;
import org.testcontainers.containers.ContainerLaunchException;
import org.testcontainers.containers.ContainerisedDockerCompose;
import org.testcontainers.containers.DockerCompose;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.FutureContainer;
import org.testcontainers.containers.LocalDockerCompose;
import org.testcontainers.containers.SocatContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.LogUtils;
import org.testcontainers.utility.ResourceReaper;

public class DockerComposeContainer<SELF extends DockerComposeContainer<SELF>>
extends FailureDetectingExternalResource
implements Startable {
    private final String identifier;
    private final List<File> composeFiles;
    private final Set<String> spawnedContainerIds = new HashSet<String>();
    private final Set<String> spawnedNetworkIds = new HashSet<String>();
    private final Map<String, Integer> scalingPreferences = new HashMap<String, Integer>();
    private DockerClient dockerClient;
    private boolean localCompose;
    private boolean pull = true;
    private boolean tailChildContainers;
    private String project;
    private final AtomicInteger nextAmbassadorPort = new AtomicInteger(2000);
    private final Map<String, Map<Integer, Integer>> ambassadorPortMappings = new ConcurrentHashMap<String, Map<Integer, Integer>>();
    private final Map<String, ComposeServiceWaitStrategyTarget> serviceInstanceMap = new ConcurrentHashMap<String, ComposeServiceWaitStrategyTarget>();
    private final Map<String, WaitAllStrategy> waitStrategyMap = new ConcurrentHashMap<String, WaitAllStrategy>();
    private final SocatContainer ambassadorContainer = new SocatContainer();
    private final Map<String, List<Consumer<OutputFrame>>> logConsumers = new ConcurrentHashMap<String, List<Consumer<OutputFrame>>>();
    private static final Object MUTEX = new Object();
    private Map<String, String> env = new HashMap<String, String>();

    @Deprecated
    public DockerComposeContainer(File composeFile, String identifier) {
        this(identifier, composeFile);
    }

    public DockerComposeContainer(File ... composeFiles) {
        this(Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(List<File> composeFiles) {
        this(Base58.randomString(6).toLowerCase(), composeFiles);
    }

    public DockerComposeContainer(String identifier, File ... composeFiles) {
        this(identifier, Arrays.asList(composeFiles));
    }

    public DockerComposeContainer(String identifier, List<File> composeFiles) {
        this.composeFiles = composeFiles;
        this.identifier = identifier;
        this.project = this.randomProjectId();
        this.dockerClient = DockerClientFactory.instance().client();
    }

    @Override
    @Deprecated
    public Statement apply(Statement base, Description description) {
        return super.apply(base, description);
    }

    @Override
    @Deprecated
    public void starting(Description description) {
        this.start();
    }

    @Override
    @Deprecated
    protected void succeeded(Description description) {
    }

    @Override
    @Deprecated
    protected void failed(Throwable e, Description description) {
    }

    @Override
    @Deprecated
    public void finished(Description description) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = MUTEX;
        synchronized (object) {
            this.registerContainersForShutdown();
            if (this.pull) {
                try {
                    this.pullImages();
                }
                catch (ContainerLaunchException e) {
                    this.logger().warn("Exception while pulling images, using local images if available", (Throwable)e);
                }
            }
            this.applyScaling();
            this.createServices();
            this.startAmbassadorContainers();
            this.waitUntilServiceStarted();
        }
    }

    private void pullImages() {
        this.runWithCompose("pull");
    }

    private void createServices() {
        this.runWithCompose("up -d");
    }

    private void waitUntilServiceStarted() {
        this.listChildContainers().forEach(this::createServiceInstance);
        this.serviceInstanceMap.forEach(this::waitUntilServiceStarted);
    }

    private void createServiceInstance(Container container) {
        String serviceName = this.getServiceNameFromContainer(container);
        ComposeServiceWaitStrategyTarget containerInstance = new ComposeServiceWaitStrategyTarget(container, this.ambassadorContainer, this.ambassadorPortMappings.getOrDefault(serviceName, new HashMap()));
        String containerId = containerInstance.getContainerId();
        if (this.tailChildContainers) {
            this.followLogs(containerId, new Slf4jLogConsumer(this.logger()).withPrefix(container.getNames()[0]));
        }
        this.logConsumers.getOrDefault(serviceName, Collections.emptyList()).forEach(consumer -> this.followLogs(containerId, (Consumer<OutputFrame>)consumer));
        this.serviceInstanceMap.putIfAbsent(serviceName, containerInstance);
    }

    private void waitUntilServiceStarted(String serviceName, ComposeServiceWaitStrategyTarget serviceInstance) {
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.get(serviceName);
        if (waitAllStrategy != null) {
            waitAllStrategy.waitUntilReady(serviceInstance);
        }
    }

    private String getServiceNameFromContainer(Container container) {
        String containerName = container.getLabels().get("com.docker.compose.service");
        String containerNumber = container.getLabels().get("com.docker.compose.container-number");
        return String.format("%s_%s", containerName, containerNumber);
    }

    private void runWithCompose(String cmd) {
        DockerCompose dockerCompose = this.localCompose ? new LocalDockerCompose(this.composeFiles, this.project) : new ContainerisedDockerCompose(this.composeFiles, this.project);
        dockerCompose.withCommand(cmd).withEnv(this.env).invoke();
    }

    private void applyScaling() {
        if (!this.scalingPreferences.isEmpty()) {
            StringBuilder sb = new StringBuilder("scale");
            for (Map.Entry<String, Integer> scale : this.scalingPreferences.entrySet()) {
                sb.append(" ").append(scale.getKey()).append("=").append(scale.getValue());
            }
            this.runWithCompose(sb.toString());
        }
    }

    private void registerContainersForShutdown() {
        ResourceReaper.instance().registerFilterForCleanup(Arrays.asList(new AbstractMap.SimpleEntry<String, String>("label", "com.docker.compose.project=" + this.project)));
    }

    private List<Container> listChildContainers() {
        return ((List)this.dockerClient.listContainersCmd().withShowAll(true).exec()).stream().filter(container -> Arrays.stream(container.getNames()).anyMatch(name -> name.startsWith("/" + this.project))).collect(Collectors.toList());
    }

    private void startAmbassadorContainers() {
        if (!this.ambassadorPortMappings.isEmpty()) {
            this.ambassadorContainer.start();
        }
    }

    private Logger logger() {
        return LoggerFactory.getLogger(DockerComposeContainer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = MUTEX;
        synchronized (object) {
            try {
                this.ambassadorContainer.stop();
                try {
                    this.runWithCompose("down -v");
                    this.spawnedContainerIds.forEach(ResourceReaper.instance()::unregisterContainer);
                    this.spawnedNetworkIds.forEach(ResourceReaper.instance()::unregisterNetwork);
                }
                catch (Exception e) {
                    this.spawnedContainerIds.forEach(ResourceReaper.instance()::stopAndRemoveContainer);
                    this.spawnedNetworkIds.forEach(ResourceReaper.instance()::removeNetworkById);
                }
                this.spawnedContainerIds.clear();
                this.spawnedNetworkIds.clear();
            }
            finally {
                this.project = this.randomProjectId();
            }
        }
    }

    public SELF withExposedService(String serviceName, int servicePort) {
        return this.withExposedService(serviceName, servicePort, Wait.defaultWaitStrategy());
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort) {
        return this.withExposedService(serviceName + "_" + instance, servicePort);
    }

    public DockerComposeContainer withExposedService(String serviceName, int instance, int servicePort, WaitStrategy waitStrategy) {
        return this.withExposedService(serviceName + "_" + instance, servicePort, waitStrategy);
    }

    public SELF withExposedService(String serviceName, int servicePort, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked @NonNull but is null");
        }
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        int ambassadorPort = this.nextAmbassadorPort.getAndIncrement();
        this.ambassadorPortMappings.computeIfAbsent(serviceInstanceName, __ -> new ConcurrentHashMap()).put(servicePort, ambassadorPort);
        this.ambassadorContainer.withTarget(ambassadorPort, serviceInstanceName, servicePort);
        this.ambassadorContainer.addLink(new FutureContainer(this.project + "_" + serviceInstanceName), serviceInstanceName);
        this.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this.self();
    }

    private String getServiceInstanceName(String serviceName) {
        String serviceInstanceName = serviceName;
        if (!serviceInstanceName.matches(".*_[0-9]+")) {
            serviceInstanceName = serviceInstanceName + "_1";
        }
        return serviceInstanceName;
    }

    private void addWaitStrategy(String serviceInstanceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked @NonNull but is null");
        }
        WaitAllStrategy waitAllStrategy = this.waitStrategyMap.computeIfAbsent(serviceInstanceName, __ -> new WaitAllStrategy(WaitAllStrategy.Mode.WITH_MAXIMUM_OUTER_TIMEOUT).withStartupTimeout(Duration.ofMinutes(30L)));
        waitAllStrategy.withStrategy(waitStrategy);
    }

    public SELF waitingFor(String serviceName, @NonNull WaitStrategy waitStrategy) {
        if (waitStrategy == null) {
            throw new NullPointerException("waitStrategy is marked @NonNull but is null");
        }
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        this.addWaitStrategy(serviceInstanceName, waitStrategy);
        return this.self();
    }

    public String getServiceHost(String serviceName, Integer servicePort) {
        return this.ambassadorContainer.getContainerIpAddress();
    }

    public Integer getServicePort(String serviceName, Integer servicePort) {
        return this.ambassadorContainer.getMappedPort(this.ambassadorPortMappings.get(this.getServiceInstanceName(serviceName)).get(servicePort));
    }

    public SELF withScaledService(String serviceBaseName, int numInstances) {
        this.scalingPreferences.put(serviceBaseName, numInstances);
        return this.self();
    }

    public SELF withEnv(String key, String value) {
        this.env.put(key, value);
        return this.self();
    }

    public SELF withEnv(Map<String, String> env) {
        env.forEach(this.env::put);
        return this.self();
    }

    public SELF withLocalCompose(boolean localCompose) {
        this.localCompose = localCompose;
        return this.self();
    }

    public SELF withPull(boolean pull) {
        this.pull = pull;
        return this.self();
    }

    public SELF withTailChildContainers(boolean tailChildContainers) {
        this.tailChildContainers = tailChildContainers;
        return this.self();
    }

    public SELF withLogConsumer(String serviceName, Consumer<OutputFrame> consumer) {
        String serviceInstanceName = this.getServiceInstanceName(serviceName);
        List consumers = this.logConsumers.getOrDefault(serviceInstanceName, new ArrayList());
        consumers.add(consumer);
        this.logConsumers.putIfAbsent(serviceInstanceName, consumers);
        return this.self();
    }

    private void followLogs(String containerId, Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(DockerClientFactory.instance().client(), containerId, consumer);
    }

    private SELF self() {
        return (SELF)this;
    }

    private String randomProjectId() {
        return this.identifier + Base58.randomString(6).toLowerCase();
    }
}

