/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

class ComposeServiceWaitStrategyTarget
implements WaitStrategyTarget {
    private final Container container;
    private final GenericContainer proxyContainer;
    @NonNull
    private Map<Integer, Integer> mappedPorts;
    private final AtomicReference<Object> containerInfo = new AtomicReference();

    ComposeServiceWaitStrategyTarget(Container container, GenericContainer proxyContainer, @NonNull Map<Integer, Integer> mappedPorts) {
        if (mappedPorts == null) {
            throw new NullPointerException("mappedPorts is marked @NonNull but is null");
        }
        this.container = container;
        this.proxyContainer = proxyContainer;
        this.mappedPorts = new HashMap<Integer, Integer>(mappedPorts);
    }

    @Override
    public List<Integer> getExposedPorts() {
        return new ArrayList<Integer>(this.mappedPorts.keySet());
    }

    @Override
    public Integer getMappedPort(int originalPort) {
        return this.proxyContainer.getMappedPort(this.mappedPorts.get(originalPort));
    }

    @Override
    public String getContainerIpAddress() {
        return this.proxyContainer.getContainerIpAddress();
    }

    @Override
    public String getContainerId() {
        return this.container.getId();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposeServiceWaitStrategyTarget)) {
            return false;
        }
        ComposeServiceWaitStrategyTarget other = (ComposeServiceWaitStrategyTarget)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Container this$container = this.container;
        Container other$container = other.container;
        if (this$container == null ? other$container != null : !((Object)this$container).equals(other$container)) {
            return false;
        }
        GenericContainer this$proxyContainer = this.proxyContainer;
        GenericContainer other$proxyContainer = other.proxyContainer;
        if (this$proxyContainer == null ? other$proxyContainer != null : !((Object)this$proxyContainer).equals(other$proxyContainer)) {
            return false;
        }
        Map<Integer, Integer> this$mappedPorts = this.mappedPorts;
        Map<Integer, Integer> other$mappedPorts = other.mappedPorts;
        if (this$mappedPorts == null ? other$mappedPorts != null : !((Object)this$mappedPorts).equals(other$mappedPorts)) {
            return false;
        }
        InspectContainerResponse this$containerInfo = this.getContainerInfo();
        InspectContainerResponse other$containerInfo = other.getContainerInfo();
        return !(this$containerInfo == null ? other$containerInfo != null : !this$containerInfo.equals(other$containerInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComposeServiceWaitStrategyTarget;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Container $container = this.container;
        result = result * 59 + ($container == null ? 43 : ((Object)$container).hashCode());
        GenericContainer $proxyContainer = this.proxyContainer;
        result = result * 59 + ($proxyContainer == null ? 43 : ((Object)$proxyContainer).hashCode());
        Map<Integer, Integer> $mappedPorts = this.mappedPorts;
        result = result * 59 + ($mappedPorts == null ? 43 : ((Object)$mappedPorts).hashCode());
        InspectContainerResponse $containerInfo = this.getContainerInfo();
        result = result * 59 + ($containerInfo == null ? 43 : $containerInfo.hashCode());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InspectContainerResponse getContainerInfo() {
        Object value = this.containerInfo.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.containerInfo;
            synchronized (atomicReference) {
                value = this.containerInfo.get();
                if (value == null) {
                    InspectContainerResponse actualValue = DockerClientFactory.instance().client().inspectContainerCmd(this.getContainerId()).exec();
                    value = actualValue == null ? this.containerInfo : actualValue;
                    this.containerInfo.set(value);
                }
            }
        }
        return (InspectContainerResponse)(value == this.containerInfo ? null : value);
    }
}

