/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.version;

import java.net.URI;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.version.AbstractAddressingVersion;

public class Addressing10
extends AbstractAddressingVersion {
    private static final String NAMESPACE_URI = "http://www.w3.org/2005/08/addressing";

    @Override
    public void addAddressingHeaders(SoapMessage message, MessageAddressingProperties map) {
        Assert.notNull((Object)map.getAction(), (String)"'Action' is required");
        super.addAddressingHeaders(message, map);
    }

    @Override
    public boolean hasRequiredProperties(MessageAddressingProperties map) {
        if (map.getAction() == null) {
            return false;
        }
        if (map.getReplyTo() != null || map.getFaultTo() != null) {
            return map.getMessageId() != null;
        }
        return true;
    }

    @Override
    protected String getNamespaceUri() {
        return NAMESPACE_URI;
    }

    @Override
    protected QName getReferencePropertiesName() {
        return null;
    }

    @Override
    protected URI getDefaultTo() {
        return this.getAnonymous();
    }

    @Override
    protected EndpointReference getDefaultReplyTo(EndpointReference from) {
        return new EndpointReference(this.getAnonymous());
    }

    @Override
    protected final URI getAnonymous() {
        return URI.create("http://www.w3.org/2005/08/addressing/anonymous");
    }

    @Override
    protected final URI getNone() {
        return URI.create("http://www.w3.org/2005/08/addressing/none");
    }

    @Override
    protected final QName getMessageAddressingHeaderRequiredFaultSubcode() {
        return new QName(NAMESPACE_URI, "MessageAddressingHeaderRequired", this.getNamespacePrefix());
    }

    @Override
    protected final String getMessageAddressingHeaderRequiredFaultReason() {
        return "A required header representing a Message Addressing Property is not present";
    }

    @Override
    protected QName getInvalidAddressingHeaderFaultSubcode() {
        return new QName(NAMESPACE_URI, "InvalidAddressingHeader", this.getNamespacePrefix());
    }

    @Override
    protected String getInvalidAddressingHeaderFaultReason() {
        return "A header representing a Message Addressing Property is not valid and the message cannot be processed";
    }

    public String toString() {
        return "WS-Addressing 1.0";
    }
}

