/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.security;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

class SpringSessionBackedSessionInformation<S extends Session>
extends SessionInformation {
    static final String EXPIRED_ATTR = SpringSessionBackedSessionInformation.class.getName() + ".EXPIRED";
    private static final Log logger = LogFactory.getLog(SpringSessionBackedSessionInformation.class);
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private final SessionRepository<S> sessionRepository;

    SpringSessionBackedSessionInformation(S session, SessionRepository<S> sessionRepository) {
        super((Object)SpringSessionBackedSessionInformation.resolvePrincipal(session), session.getId(), Date.from(session.getLastAccessedTime()));
        this.sessionRepository = sessionRepository;
        Boolean expired = (Boolean)session.getAttribute(EXPIRED_ATTR);
        if (Boolean.TRUE.equals(expired)) {
            super.expireNow();
        }
    }

    private static String resolvePrincipal(Session session) {
        String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        SecurityContext securityContext = (SecurityContext)session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (securityContext != null && securityContext.getAuthentication() != null) {
            return securityContext.getAuthentication().getName();
        }
        return "";
    }

    public void expireNow() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expiring session " + this.getSessionId() + " for user '" + String.valueOf(this.getPrincipal()) + "', presumably because maximum allowed concurrent sessions was exceeded"));
        }
        super.expireNow();
        S session = this.sessionRepository.findById(this.getSessionId());
        if (session != null) {
            session.setAttribute(EXPIRED_ATTR, Boolean.TRUE);
            this.sessionRepository.save(session);
        } else {
            logger.info((Object)("Could not find Session with id " + this.getSessionId() + " to mark as expired"));
        }
    }
}

