/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.time.Instant;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;

public final class OpaqueTokenAuthenticationProvider
implements AuthenticationProvider {
    private static final BearerTokenError DEFAULT_INVALID_TOKEN = OpaqueTokenAuthenticationProvider.invalidToken("An error occurred while attempting to introspect the token: Invalid token");
    private OpaqueTokenIntrospector introspector;

    public OpaqueTokenAuthenticationProvider(OpaqueTokenIntrospector introspector) {
        Assert.notNull((Object)introspector, (String)"introspector cannot be null");
        this.introspector = introspector;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2AuthenticatedPrincipal principal;
        if (!(authentication instanceof BearerTokenAuthenticationToken)) {
            return null;
        }
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        try {
            principal = this.introspector.introspect(bearer.getToken());
        }
        catch (OAuth2IntrospectionException failed) {
            BearerTokenError invalidToken = OpaqueTokenAuthenticationProvider.invalidToken(failed.getMessage());
            throw new OAuth2AuthenticationException((OAuth2Error)invalidToken);
        }
        AbstractAuthenticationToken result = this.convert(principal, bearer.getToken());
        result.setDetails(bearer.getDetails());
        return result;
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private AbstractAuthenticationToken convert(OAuth2AuthenticatedPrincipal principal, String token) {
        Instant iat = (Instant)principal.getAttribute("iat");
        Instant exp = (Instant)principal.getAttribute("exp");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, token, iat, exp);
        return new BearerTokenAuthentication(principal, accessToken, principal.getAuthorities());
    }

    private static BearerTokenError invalidToken(String message) {
        try {
            return new BearerTokenError("invalid_token", HttpStatus.UNAUTHORIZED, message, "https://tools.ietf.org/html/rfc7662#section-2.2");
        }
        catch (IllegalArgumentException malformed) {
            return DEFAULT_INVALID_TOKEN;
        }
    }
}

