/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.user;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class OAuth2UserAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 550L;
    private final String authority;
    private final Map<String, Object> attributes;

    public OAuth2UserAuthority(Map<String, Object> attributes) {
        this("ROLE_USER", attributes);
    }

    public OAuth2UserAuthority(String authority, Map<String, Object> attributes) {
        Assert.hasText((String)authority, (String)"authority cannot be empty");
        Assert.notEmpty(attributes, (String)"attributes cannot be empty");
        this.authority = authority;
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(attributes));
    }

    public String getAuthority() {
        return this.authority;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2UserAuthority that = (OAuth2UserAuthority)obj;
        if (!this.getAuthority().equals(that.getAuthority())) {
            return false;
        }
        return this.getAttributes().equals(that.getAttributes());
    }

    public int hashCode() {
        int result = this.getAuthority().hashCode();
        result = 31 * result + this.getAttributes().hashCode();
        return result;
    }

    public String toString() {
        return this.getAuthority();
    }
}

