/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.web.reactive.function;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import reactor.core.publisher.Mono;

class OAuth2AccessTokenResponseBodyExtractor
implements BodyExtractor<Mono<OAuth2AccessTokenResponse>, ReactiveHttpInputMessage> {
    private static final String INVALID_TOKEN_RESPONSE_ERROR_CODE = "invalid_token_response";

    OAuth2AccessTokenResponseBodyExtractor() {
    }

    public Mono<OAuth2AccessTokenResponse> extract(ReactiveHttpInputMessage inputMessage, BodyExtractor.Context context) {
        ParameterizedTypeReference<Map<String, Object>> type = new ParameterizedTypeReference<Map<String, Object>>(){};
        BodyExtractor delegate = BodyExtractors.toMono((ParameterizedTypeReference)type);
        return ((Mono)delegate.extract(inputMessage, context)).map(OAuth2AccessTokenResponseBodyExtractor::parse).flatMap(OAuth2AccessTokenResponseBodyExtractor::oauth2AccessTokenResponse).map(OAuth2AccessTokenResponseBodyExtractor::oauth2AccessTokenResponse);
    }

    private static TokenResponse parse(Map<String, Object> json) {
        try {
            return TokenResponse.parse((JSONObject)new JSONObject(json));
        }
        catch (ParseException pe) {
            OAuth2Error oauth2Error = new OAuth2Error(INVALID_TOKEN_RESPONSE_ERROR_CODE, "An error occurred parsing the Access Token response: " + pe.getMessage(), null);
            throw new OAuth2AuthorizationException(oauth2Error, (Throwable)pe);
        }
    }

    private static Mono<AccessTokenResponse> oauth2AccessTokenResponse(TokenResponse tokenResponse) {
        if (tokenResponse.indicatesSuccess()) {
            return Mono.just((Object)tokenResponse).cast(AccessTokenResponse.class);
        }
        TokenErrorResponse tokenErrorResponse = (TokenErrorResponse)tokenResponse;
        ErrorObject errorObject = tokenErrorResponse.getErrorObject();
        OAuth2Error oauth2Error = errorObject == null ? new OAuth2Error("server_error") : new OAuth2Error(errorObject.getCode() != null ? errorObject.getCode() : "server_error", errorObject.getDescription(), errorObject.getURI() != null ? errorObject.getURI().toString() : null);
        return Mono.error((Throwable)new OAuth2AuthorizationException(oauth2Error));
    }

    private static OAuth2AccessTokenResponse oauth2AccessTokenResponse(AccessTokenResponse accessTokenResponse) {
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        OAuth2AccessToken.TokenType accessTokenType = null;
        if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(accessToken.getType().getValue())) {
            accessTokenType = OAuth2AccessToken.TokenType.BEARER;
        }
        long expiresIn = accessToken.getLifetime();
        LinkedHashSet<String> scopes = accessToken.getScope() == null ? Collections.emptySet() : new LinkedHashSet<String>(accessToken.getScope().toStringList());
        String refreshToken = null;
        if (accessTokenResponse.getTokens().getRefreshToken() != null) {
            refreshToken = accessTokenResponse.getTokens().getRefreshToken().getValue();
        }
        LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>(accessTokenResponse.getCustomParameters());
        return OAuth2AccessTokenResponse.withToken(accessToken.getValue()).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
    }
}

