/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.http.converter;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.http.converter.HttpMessageConverters;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OAuth2AccessTokenResponseHttpMessageConverter
extends AbstractHttpMessageConverter<OAuth2AccessTokenResponse> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final ParameterizedTypeReference<Map<String, Object>> PARAMETERIZED_RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    protected Converter<Map<String, String>, OAuth2AccessTokenResponse> tokenResponseConverter = new OAuth2AccessTokenResponseConverter();
    protected Converter<OAuth2AccessTokenResponse, Map<String, String>> tokenResponseParametersConverter = new OAuth2AccessTokenResponseParametersConverter();

    public OAuth2AccessTokenResponseHttpMessageConverter() {
        super(DEFAULT_CHARSET, new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OAuth2AccessTokenResponse.class.isAssignableFrom(clazz);
    }

    protected OAuth2AccessTokenResponse readInternal(Class<? extends OAuth2AccessTokenResponse> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map tokenResponseParameters = (Map)this.jsonMessageConverter.read(PARAMETERIZED_RESPONSE_TYPE.getType(), null, inputMessage);
            return (OAuth2AccessTokenResponse)this.tokenResponseConverter.convert(tokenResponseParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString())));
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OAuth 2.0 Access Token Response: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OAuth2AccessTokenResponse tokenResponse, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            Map tokenResponseParameters = (Map)this.tokenResponseParametersConverter.convert((Object)tokenResponse);
            this.jsonMessageConverter.write((Object)tokenResponseParameters, PARAMETERIZED_RESPONSE_TYPE.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OAuth 2.0 Access Token Response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public final void setTokenResponseConverter(Converter<Map<String, String>, OAuth2AccessTokenResponse> tokenResponseConverter) {
        Assert.notNull(tokenResponseConverter, (String)"tokenResponseConverter cannot be null");
        this.tokenResponseConverter = tokenResponseConverter;
    }

    public final void setTokenResponseParametersConverter(Converter<OAuth2AccessTokenResponse, Map<String, String>> tokenResponseParametersConverter) {
        Assert.notNull(tokenResponseParametersConverter, (String)"tokenResponseParametersConverter cannot be null");
        this.tokenResponseParametersConverter = tokenResponseParametersConverter;
    }

    private static class OAuth2AccessTokenResponseParametersConverter
    implements Converter<OAuth2AccessTokenResponse, Map<String, String>> {
        private OAuth2AccessTokenResponseParametersConverter() {
        }

        public Map<String, String> convert(OAuth2AccessTokenResponse tokenResponse) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            long expiresIn = -1L;
            if (tokenResponse.getAccessToken().getExpiresAt() != null) {
                expiresIn = ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
            }
            parameters.put("access_token", tokenResponse.getAccessToken().getTokenValue());
            parameters.put("token_type", tokenResponse.getAccessToken().getTokenType().getValue());
            parameters.put("expires_in", String.valueOf(expiresIn));
            if (!CollectionUtils.isEmpty(tokenResponse.getAccessToken().getScopes())) {
                parameters.put("scope", StringUtils.collectionToDelimitedString(tokenResponse.getAccessToken().getScopes(), (String)" "));
            }
            if (tokenResponse.getRefreshToken() != null) {
                parameters.put("refresh_token", tokenResponse.getRefreshToken().getTokenValue());
            }
            if (!CollectionUtils.isEmpty(tokenResponse.getAdditionalParameters())) {
                for (Map.Entry<String, Object> entry : tokenResponse.getAdditionalParameters().entrySet()) {
                    parameters.put(entry.getKey(), entry.getValue().toString());
                }
            }
            return parameters;
        }
    }

    private static class OAuth2AccessTokenResponseConverter
    implements Converter<Map<String, String>, OAuth2AccessTokenResponse> {
        private static final Set<String> TOKEN_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("access_token", "token_type", "expires_in", "refresh_token", "scope"));

        private OAuth2AccessTokenResponseConverter() {
        }

        public OAuth2AccessTokenResponse convert(Map<String, String> tokenResponseParameters) {
            String accessToken = tokenResponseParameters.get("access_token");
            OAuth2AccessToken.TokenType accessTokenType = null;
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(tokenResponseParameters.get("token_type"))) {
                accessTokenType = OAuth2AccessToken.TokenType.BEARER;
            }
            long expiresIn = 0L;
            if (tokenResponseParameters.containsKey("expires_in")) {
                try {
                    expiresIn = Long.parseLong(tokenResponseParameters.get("expires_in"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Set<String> scopes = Collections.emptySet();
            if (tokenResponseParameters.containsKey("scope")) {
                String scope = tokenResponseParameters.get("scope");
                scopes = new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
            }
            String refreshToken = tokenResponseParameters.get("refresh_token");
            LinkedHashMap<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> entry : tokenResponseParameters.entrySet()) {
                if (TOKEN_RESPONSE_PARAMETER_NAMES.contains(entry.getKey())) continue;
                additionalParameters.put(entry.getKey(), entry.getValue());
            }
            return OAuth2AccessTokenResponse.withToken(accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
        }
    }
}

